/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum EnumHippogryphTypes {
    BLACK(false, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY),
    BROWN(false, BiomeDictionary.Type.MOUNTAIN),
    GRAY(false, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST),
    CHESTNUT(false, BiomeDictionary.Type.FOREST),
    CREAMY(false, BiomeDictionary.Type.SAVANNA),
    DARK_BROWN(false, BiomeDictionary.Type.CONIFEROUS),
    WHITE(false, BiomeDictionary.Type.SNOWY),
    RAPTOR(true, new BiomeDictionary.Type[0]),
    ALEX(true, new BiomeDictionary.Type[0]),
    DODO(true, new BiomeDictionary.Type[0]);

    public boolean developer;
    public BiomeDictionary.Type[] spawnBiomes;
    public ResourceLocation TEXTURE;
    public ResourceLocation TEXTURE_BLINK;

    private EnumHippogryphTypes(boolean developer, BiomeDictionary.Type ... biomes) {
        this.spawnBiomes = biomes;
        this.developer = developer;
        this.TEXTURE = new ResourceLocation("iceandfire:textures/models/hippogryph/" + this.name().toLowerCase() + ".png");
        this.TEXTURE_BLINK = new ResourceLocation("iceandfire:textures/models/hippogryph/" + this.name().toLowerCase() + "_blink.png");
    }

    public static EnumHippogryphTypes[] getWildTypes() {
        return new EnumHippogryphTypes[]{BLACK, BROWN, GRAY, CHESTNUT, CREAMY, DARK_BROWN, WHITE};
    }

    public static EnumHippogryphTypes getRandomType() {
        return EnumHippogryphTypes.getWildTypes()[new Random().nextInt(EnumHippogryphTypes.getWildTypes().length - 1)];
    }

    public static EnumHippogryphTypes getBiomeType(Biome biome) {
        ArrayList<EnumHippogryphTypes> types = new ArrayList<EnumHippogryphTypes>();
        for (EnumHippogryphTypes type : EnumHippogryphTypes.getWildTypes()) {
            for (BiomeDictionary.Type biomeTypes : type.spawnBiomes) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)biomeTypes)) continue;
                types.add(type);
            }
        }
        if (types.isEmpty()) {
            return EnumHippogryphTypes.getRandomType();
        }
        if (types.contains((Object)GRAY) && types.contains((Object)CHESTNUT)) {
            return GRAY;
        }
        return (EnumHippogryphTypes)((Object)types.get(new Random().nextInt(types.size())));
    }
}

