/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util.collections;

import java.util.Map;

public class ImmutablePair<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    public static <K, V> ImmutablePair<K, V> of(K key, V value) {
        return new ImmutablePair<K, V>(key, value);
    }

    private ImmutablePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("Tried to set value in ImmutablePair");
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + 65536 * this.key.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutablePair)) {
            return false;
        }
        ImmutablePair other = (ImmutablePair)obj;
        return this.key.equals(other.key) && this.value.equals(other.value);
    }
}

