/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util.collections;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ImmutableHashTable<R, C, V>
implements Table<R, C, V> {
    private final Map<R, Map<C, V>> TABLE;

    private ImmutableHashTable(Map<R, Map<C, V>> table) {
        this.TABLE = table;
    }

    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return false;
        }
        Map<C, V> map = this.TABLE.get(rowKey);
        if (map == null) {
            return false;
        }
        return map.containsKey(columnKey);
    }

    public boolean containsRow(@Nullable Object rowKey) {
        return this.TABLE.containsKey(rowKey);
    }

    public boolean containsColumn(@Nullable Object columnKey) {
        return this.TABLE.values().stream().anyMatch(x -> x.containsKey(columnKey));
    }

    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        return this.TABLE.values().stream().flatMap(x -> x.values().stream()).anyMatch(x -> x.equals(value));
    }

    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = this.TABLE.get(rowKey);
        return map == null ? null : (V)map.get(columnKey);
    }

    public boolean isEmpty() {
        return this.TABLE.isEmpty();
    }

    public int size() {
        if (this.TABLE.isEmpty()) {
            return 0;
        }
        return this.TABLE.values().stream().mapToInt(Map::size).sum();
    }

    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @Deprecated
    public V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @Deprecated
    public V remove(@Nullable Object rowKey, @Nullable Object columnKey) {
        throw new UnsupportedOperationException();
    }

    public ImmutableMap<C, V> row(R rowKey) {
        Map<C, V> map = this.TABLE.get(rowKey);
        return map == null ? ImmutableMap.of() : ImmutableMap.copyOf(this.TABLE.get(rowKey));
    }

    public ImmutableMap<R, V> column(C columnKey) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.TABLE.forEach((r, c) -> {
            Object v = c.get(columnKey);
            if (v != null) {
                b.put(r, v);
            }
        });
        return b.build();
    }

    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)this.TABLE.entrySet().stream().map(r -> ((Map)r.getValue()).entrySet().stream().map(c -> Tables.immutableCell(r.getKey(), c.getKey(), c.getValue())).collect(Collectors.toSet())).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<R> rowKeySet() {
        return ImmutableSet.copyOf(this.TABLE.keySet());
    }

    public ImmutableSet<C> columnKeySet() {
        return ImmutableSet.copyOf((Collection)((Collection)this.TABLE.values().stream().flatMap(x -> x.keySet().stream()).collect(ImmutableSet.toImmutableSet())));
    }

    public ImmutableSet<V> values() {
        return (ImmutableSet)this.TABLE.values().stream().flatMap(x -> x.values().stream()).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.copyOf(this.TABLE);
    }

    public ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Object c : this.columnKeySet()) {
            b.put(c, this.column((C)c));
        }
        return b.build();
    }

    public static class Builder<R, C, V> {
        private final Map<R, Map<C, V>> TABLE = new HashMap<R, Map<C, V>>();

        @Nullable
        public V put(R rowKey, C columnKey, V value) {
            Map<C, V> map = this.TABLE.get(rowKey);
            if (map == null) {
                map = new HashMap<C, V>();
                map.put(columnKey, value);
                this.TABLE.put(rowKey, map);
                return null;
            }
            V old = map.get(columnKey);
            map.put(columnKey, value);
            return old;
        }

        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            table.rowMap().forEach((r, x) -> x.forEach((c, v) -> this.put(r, c, v)));
        }

        public ImmutableHashTable<R, C, V> build() {
            return new ImmutableHashTable(this.TABLE);
        }
    }
}

