/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.item.tool;

import com.alcatrazescapee.alcatrazcore.client.IModelProvider;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class ItemToolCore
extends ItemTool
implements IModelProvider {
    protected final int harvestLevel;
    protected Set<Material> effectiveMaterials = new HashSet<Material>();

    public ItemToolCore(Item.ToolMaterial material) {
        super(material, (Set)Sets.newHashSet());
        this.harvestLevel = material.func_77996_d();
    }

    public ItemToolCore(Item.ToolMaterial material, float damage, float speed) {
        super(damage, speed, material, (Set)Sets.newHashSet());
        this.harvestLevel = material.func_77996_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.effectiveMaterials.contains(state.func_185904_a()) ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public boolean func_150897_b(IBlockState state) {
        return this.effectiveMaterials.contains(state.func_185904_a()) || this.harvestLevel > state.func_177230_c().getHarvestLevel(state);
    }

    protected void addToolClass(ToolClass clazz) {
        this.setHarvestLevel(clazz.name().toLowerCase(), this.harvestLevel);
    }

    protected static enum ToolClass {
        PICKAXE,
        SHOVEL,
        AXE;

    }
}

