/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.command;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BNBCommand
implements ICommand {
    private static final List<String> aliases = new ArrayList<String>();
    Gson gson = new Gson();

    public String func_71517_b() {
        return "bnb";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public String func_71518_a(ICommandSender sender) {
        return "bnbgaminglib.cmd.item.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            if (args.length <= 0) return;
            if ("hand".equalsIgnoreCase(args[0])) {
                EntityPlayer player = (EntityPlayer)sender;
                ItemStack stack = player.func_184614_ca();
                if (stack != null && !stack.func_190926_b()) {
                    String syntax = BNBCommand.getStringForStackNew(stack);
                    sender.func_145747_a(new TextComponentString(syntax).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clipboard " + syntax))));
                    sender.func_145747_a(new TextComponentString("[Copied To Clipboard]").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Hand must contain an item in order to print syntax."));
                }
                return;
            } else if ("hotbar".equalsIgnoreCase(args[0])) {
                EntityPlayer player = (EntityPlayer)sender;
                String syntax = "";
                for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_190926_b()) continue;
                    if (!syntax.isEmpty()) {
                        syntax = syntax.concat("\n");
                    }
                    syntax = syntax.concat(BNBCommand.getStringForStackNew(stack));
                }
                if (!syntax.isEmpty()) {
                    sender.func_145747_a(new TextComponentString(syntax).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clipboard " + syntax))));
                    sender.func_145747_a(new TextComponentString("[Copied To Clipboard]").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Hotbar must contain an item in order to print syntax."));
                }
                return;
            } else {
                if (!"block".equalsIgnoreCase(args[0])) throw new WrongUsageException("bnbgaminglib.cmd.item.usage", new Object[0]);
                EntityPlayer player = (EntityPlayer)sender;
                World world = player.field_70170_p;
                Vec3d vec3d = player.func_174824_e(0.0f);
                Vec3d vec3d1 = player.func_70676_i(0.0f);
                Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 4.0, vec3d1.field_72448_b * 4.0, vec3d1.field_72449_c * 4.0);
                RayTraceResult result = world.func_147447_a(vec3d, vec3d2, false, false, true);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.func_178782_a() != null) {
                    BlockPos blockpos = result.func_178782_a();
                    IBlockState state = world.func_180495_p(blockpos);
                    state = state.func_185899_b((IBlockAccess)world, blockpos);
                    String syntax = this.getStringForBlock(state, world.func_175625_s(blockpos));
                    sender.func_145747_a(new TextComponentString(syntax).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clipboard " + syntax))));
                    sender.func_145747_a(new TextComponentString("[Copied To Clipboard]").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("No block found at mouseover location."));
                }
            }
            return;
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Command can only be used by players!"));
        }
    }

    private static String getStringForStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && !compound.func_82582_d()) {
            return "\"" + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString() + "\", " + meta + ", " + stack.func_190916_E() + ", " + compound.toString();
        }
        return "\"" + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString() + "\", " + meta + ", " + stack.func_190916_E();
    }

    private static String getStringForStackNew(ItemStack stack) {
        PotionType potiontype;
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> ores = new ArrayList<String>();
        for (int ore : oreIDs) {
            ores.add(OreDictionary.getOreName((int)ore));
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        NBTTagCompound compound = stack.func_77978_p();
        String string = "<";
        string = string.concat(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
        if (!ores.isEmpty()) {
            string = string.concat(", ore:" + (String)ores.get(0));
        }
        string = string.concat(", meta:" + meta);
        string = string.concat(", count:" + stack.func_190916_E());
        if (item.func_77645_m()) {
            string = string.concat(", durability:" + item.getDamage(stack));
        }
        if (!enchantments.isEmpty()) {
            boolean array = enchantments.size() > 1;
            string = array ? string.concat(", enchant:[") : string.concat(", enchant:");
            boolean first = true;
            for (Map.Entry enchant : enchantments.entrySet()) {
                if (first) {
                    string = string.concat(Enchantment.field_185264_b.func_177774_c(enchant.getKey()) + ":" + enchant.getValue());
                    first = false;
                    continue;
                }
                string = string.concat(", " + Enchantment.field_185264_b.func_177774_c(enchant.getKey()) + ":" + enchant.getValue());
            }
            if (array) {
                string = string.concat("]");
            }
        }
        if ((potiontype = PotionUtils.func_185191_c((ItemStack)stack)) != null && potiontype != PotionTypes.field_185229_a) {
            string = string.concat(", potion:" + PotionType.field_185176_a.func_177774_c((Object)potiontype));
        }
        if (compound != null && !compound.func_82582_d()) {
            string = string.concat(", nbt:" + compound.toString());
        }
        return string.concat(">");
    }

    private String getStringForBlock(IBlockState state, TileEntity tile) {
        String string = "<";
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        ArrayList<String> ores = new ArrayList<String>();
        if (item != Items.field_190931_a) {
            int[] oreIDs;
            ItemStack stack = new ItemStack(item, 1, block.func_180651_a(state));
            for (int ore : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
                ores.add(OreDictionary.getOreName((int)ore));
            }
        }
        string = string.concat(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
        if (!ores.isEmpty()) {
            string = string.concat(", ore:" + (String)ores.get(0));
        }
        string = string.concat(", meta:" + block.func_176201_c(state));
        Map<String, String> stateMap = this.buildStateMap(state);
        if (!stateMap.isEmpty()) {
            String stateString = this.gson.toJson(stateMap);
            string = string.concat(", state:" + stateString);
        }
        if (tile != null) {
            NBTTagCompound tileNBT = tile.serializeNBT();
            string = string.concat(", tile:" + tileNBT.toString());
        }
        return string.concat(">");
    }

    private <T extends Comparable<T>> Map<String, String> buildStateMap(IBlockState state) {
        LinkedHashMap<String, String> stateMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : state.func_177228_b().entrySet()) {
            IProperty iproperty = (IProperty)entry.getKey();
            Comparable t = (Comparable)entry.getValue();
            String s = iproperty.func_177702_a(t);
            stateMap.put(iproperty.func_177701_a(), s);
        }
        return stateMap;
    }

    public int compareTo(ICommand arg0) {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])new String[]{"hand", "hotbar", "block"}) : Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

