/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.network.MessageConsumer;
import com.bloodnbonesgaming.lib.network.NetworkManager;
import com.bloodnbonesgaming.lib.util.LogHelper;
import com.bloodnbonesgaming.lib.util.ModManager;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public abstract class BNBGamingMod {
    protected LogHelper log;
    protected ModContainer mod;

    public BNBGamingMod() {
        Mod.CustomProperty[] meta;
        Class<?> clazz = this.getClass();
        if (!clazz.isAnnotationPresent(Mod.class)) {
            FMLLog.log((String)"bnbgaminglib", (Level)Level.ERROR, (String)"Subclass of BNBGamingMod does not have @Mod annotation! Things aren't going to work!", (Object[])new Object[0]);
            return;
        }
        Mod ann = clazz.getAnnotation(Mod.class);
        this.log = new LogHelper(ann.modid());
        this.mod = (ModContainer)Loader.instance().getIndexedModList().get(ann.modid());
        if (this.mod == null) {
            this.log.warn("Unable to retrieve ModContainer from FML! Things aren't going to work!");
        }
        if (!ModManager.registerMod(ann.modid(), this)) {
            this.log.warn("Failed to register with ModManager! Is there an ID conflict?");
        }
        if ((meta = ann.customProperties()) != null) {
            block16: for (Mod.CustomProperty prop : meta) {
                switch (prop.k().toLowerCase()) {
                    case "messageconsumer": {
                        MessageConsumer consumer;
                        Class<?> consumerClass;
                        try {
                            consumerClass = Class.forName(prop.v());
                            consumer = (MessageConsumer)consumerClass.newInstance();
                            NetworkManager.INSTANCE.registerConsumer(Side.SERVER, consumer);
                            NetworkManager.INSTANCE.registerConsumer(Side.CLIENT, consumer);
                        }
                        catch (Exception e) {
                            BNBGamingLib.libInstance.log.error(String.format("Failed to read messageConsumer property of submod %s!", ann.modid()));
                        }
                        continue block16;
                    }
                    case "clientmessageconsumer": {
                        MessageConsumer consumer;
                        Class<?> consumerClass;
                        try {
                            consumerClass = Class.forName(prop.v());
                            consumer = (MessageConsumer)consumerClass.newInstance();
                            NetworkManager.INSTANCE.registerConsumer(Side.CLIENT, consumer);
                        }
                        catch (Exception e) {
                            BNBGamingLib.libInstance.log.error(String.format("Failed to read clientMessageConsumer property of submod %s!", ann.modid()));
                        }
                        continue block16;
                    }
                    case "servermessageconsumer": {
                        MessageConsumer consumer;
                        Class<?> consumerClass;
                        try {
                            consumerClass = Class.forName(prop.v());
                            consumer = (MessageConsumer)consumerClass.newInstance();
                            NetworkManager.INSTANCE.registerConsumer(Side.SERVER, consumer);
                            continue block16;
                        }
                        catch (Exception e) {
                            BNBGamingLib.libInstance.log.error(String.format("Failed to read serverMessageConsumer property of submod %s!", ann.modid()));
                        }
                    }
                }
            }
        }
    }

    public LogHelper getLog() {
        return this.log;
    }

    public ModContainer getMod() {
        return this.mod;
    }

    public void setLog(LogHelper log) {
        this.log = log;
    }

    public void setMod(ModContainer mod) {
        this.mod = mod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BNBGamingMod)) {
            return false;
        }
        BNBGamingMod other = (BNBGamingMod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LogHelper this$log = this.getLog();
        LogHelper other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ModContainer this$mod = this.getMod();
        ModContainer other$mod = other.getMod();
        return !(this$mod == null ? other$mod != null : !this$mod.equals(other$mod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BNBGamingMod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LogHelper $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ModContainer $mod = this.getMod();
        result = result * 59 + ($mod == null ? 43 : $mod.hashCode());
        return result;
    }

    public String toString() {
        return "BNBGamingMod(log=" + this.getLog() + ", mod=" + this.getMod() + ")";
    }
}

