/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.fog.FogResult;
import org.orecruncher.dsurround.client.handlers.fog.VanillaFogRangeCalculator;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START = 0.63f;
    protected static final float END = 0.83f;
    protected static final float RESERVE = 10.0f;
    protected int fogDay = -1;
    protected boolean doFog = false;
    protected FogType type = FogType.NORMAL;
    protected final FogResult cache = new FogResult();

    @Override
    @Nonnull
    public String getName() {
        return "MorningFogRangeCalculator";
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float ca;
        this.cache.set(event);
        if (this.type != FogType.NONE && this.cache.getStart() > this.type.getReserve() && (ca = EnvironStateHandler.EnvironState.getWorld().func_72826_c((float)event.getRenderPartialTicks())) >= this.type.getStart() && ca <= this.type.getEnd()) {
            float mid = (this.type.getStart() + this.type.getEnd()) / 2.0f;
            float factor = 1.0f - MathStuff.abs((float)(ca - mid)) / (mid - this.type.getStart());
            float shift = this.cache.getStart() * factor;
            float newEnd = this.cache.getEnd() - shift;
            float newStart = MathStuff.clamp((float)(this.cache.getStart() - shift * 2.0f), (float)(this.type.getReserve() + 1.0f), (float)newEnd);
            this.cache.set(newStart, newEnd);
        }
        return this.cache;
    }

    @Override
    public void tick() {
        int day = EnvironStateHandler.EnvironState.getClock().getDay();
        if (this.fogDay != day) {
            int dim = EnvironStateHandler.EnvironState.getDimensionId();
            this.fogDay = day;
            boolean doFog = dim != -1 && dim != 1 && (ModOptions.fog.morningFogChance < 2 || XorShiftRandom.current().nextInt(ModOptions.fog.morningFogChance) == 0);
            this.type = doFog ? this.getFogType() : FogType.NONE;
        }
    }

    protected FogType getFogType() {
        return FogType.NORMAL;
    }

    public static enum FogType {
        NONE(0.0f, 0.0f, 0.0f),
        NORMAL(0.63f, 0.83f, 10.0f),
        LIGHT(0.73f, 0.72999996f, 15.0f),
        MEDIUM(0.53f, 0.93f, 10.0f),
        HEAVY(0.53f, 1.03f, 5.0f);

        private final float start;
        private final float end;
        private final float reserve;

        private FogType(float start, float end, float reserve) {
            this.start = start;
            this.end = end;
            this.reserve = reserve;
        }

        public float getStart() {
            return this.start;
        }

        public float getEnd() {
            return this.end;
        }

        public float getReserve() {
            return this.reserve;
        }
    }
}

