/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.footsteps.Association;
import org.orecruncher.dsurround.client.footsteps.FootStrikeLocation;
import org.orecruncher.dsurround.client.footsteps.facade.FacadeHelper;
import org.orecruncher.dsurround.registry.acoustics.AcousticRegistry;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.footstep.BlockMap;
import org.orecruncher.dsurround.registry.footstep.Substrate;
import org.orecruncher.lib.MyUtils;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class AcousticResolver {
    protected final IBlockState airState = Blocks.field_150350_a.func_176223_P();
    protected final IBlockAccess world;
    protected final BlockMap blockMap;
    protected final FootStrikeLocation loc;
    protected final double distanceToCenter;

    public AcousticResolver(@Nonnull IBlockAccess world, @Nonnull BlockMap map, @Nonnull FootStrikeLocation loc, double distanceToCenter) {
        this.world = world;
        this.blockMap = map;
        this.loc = loc;
        this.distanceToCenter = distanceToCenter;
    }

    protected IBlockState getBlockStateFacade(@Nonnull Vec3d pos) {
        return FacadeHelper.resolveState(this.loc.getEntity(), this.getBlockState(pos), this.world, pos, EnumFacing.UP);
    }

    protected IBlockState getBlockState(@Nonnull Vec3d pos) {
        return this.world.func_180495_p(new BlockPos(pos));
    }

    @Nullable
    public Association findAssociationForEvent() {
        Vec3d pos = this.loc.getStrikePosition();
        Association worked = this.resolve(pos);
        if (worked == null) {
            EntityLivingBase entity = this.loc.getEntity();
            BlockPos adj = new BlockPos(pos);
            double xdang = (entity.field_70165_t - (double)adj.func_177958_n()) * 2.0 - 1.0;
            double zdang = (entity.field_70161_v - (double)adj.func_177952_p()) * 2.0 - 1.0;
            if (Math.max(MathStuff.abs((double)xdang), MathStuff.abs((double)zdang)) > this.distanceToCenter) {
                boolean isXdangMax;
                boolean bl = isXdangMax = MathStuff.abs((double)xdang) > MathStuff.abs((double)zdang);
                worked = isXdangMax ? this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west()) : this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north());
                if (worked == null) {
                    worked = isXdangMax ? this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north()) : this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west());
                }
            }
        }
        return worked;
    }

    @Nullable
    protected Association resolve(@Nonnull Vec3d vec) {
        IBlockState in;
        Object[] acoustics = AcousticRegistry.EMPTY;
        Vec3d tPos = vec.func_72441_c(0.0, 1.0, 0.0);
        IBlockState above = this.getBlockState(tPos);
        if (above != this.airState) {
            acoustics = this.blockMap.getBlockAcoustics(above, Substrate.CARPET);
        }
        if (acoustics == AcousticRegistry.NOT_EMITTER || acoustics == AcousticRegistry.EMPTY) {
            Object[] foliage;
            IBlockState below;
            in = this.getBlockStateFacade(vec);
            if (in == this.airState && (acoustics = this.blockMap.getBlockAcoustics(below = this.getBlockState(tPos = vec.func_72441_c(0.0, -1.0, 0.0)), Substrate.FENCE)) != AcousticRegistry.EMPTY) {
                vec = tPos;
                in = below;
            }
            if (acoustics == AcousticRegistry.EMPTY) {
                acoustics = this.blockMap.getBlockAcoustics(in);
            }
            if (acoustics != AcousticRegistry.NOT_EMITTER && above != this.airState && (foliage = this.blockMap.getBlockAcoustics(above, Substrate.FOLIAGE)) != AcousticRegistry.NOT_EMITTER) {
                acoustics = (IAcoustic[])MyUtils.concatenate((Object[])acoustics, (Object[])foliage);
            }
        } else {
            vec = tPos;
            in = above;
        }
        if (acoustics == AcousticRegistry.NOT_EMITTER) {
            return null;
        }
        return new Association(in, this.loc.rebase(new BlockPos(vec)), (IAcoustic[])acoustics);
    }
}

