/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.client;

import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class ClientBonus
extends Bonus {
    private LinkedHashMap<EntityPlayer, BonusInstance> instances = new LinkedHashMap();

    public static ClientBonus getInstance(String parsableBonus) {
        return (ClientBonus)Bonus.getInstance(parsableBonus, Side.CLIENT);
    }

    public static void dropAll() {
        for (ClientBonus bonus : ClientData.bonuses.values()) {
            for (BonusInstance data : bonus.instances.values()) {
                data.update(false);
            }
        }
        ClientData.bonuses.clear();
    }

    public static void updateBonuses(EntityPlayer player) {
        for (ClientBonus bonus : ClientData.bonuses.values()) {
            bonus.update(player);
        }
    }

    @Nonnull
    public BonusInstance getBonusInstance(EntityPlayer player) {
        return this.instances.computeIfAbsent(player, k -> new BonusInstance());
    }

    public void update(EntityPlayer player) {
        this.instances.computeIfAbsent(player, k -> new BonusInstance()).update();
    }

    public class BonusInstance {
        public boolean active;

        private BonusInstance() {
            this.update();
        }

        public void update() {
            for (ABonusRequirement requirement : ClientBonus.this.bonusRequirements) {
                if (requirement.active((EntityPlayer)Minecraft.func_71410_x().field_71439_g) >= requirement.required()) continue;
                this.update(false);
                return;
            }
            this.update(true);
        }

        private void update(boolean activate) {
            if (activate) {
                if (!this.active) {
                    this.active = true;
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }
}

