/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.network;

import gigaherz.toolbelt.BeltFinder;
import gigaherz.toolbelt.Config;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SwapItems
implements IMessage {
    public int swapWith;

    public SwapItems() {
    }

    public SwapItems(int windowId) {
        this.swapWith = windowId;
    }

    public void fromBytes(ByteBuf buf) {
        this.swapWith = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.swapWith);
    }

    public static void swapItem(int swapWith, EntityPlayer player) {
        BeltFinder.BeltGetter getter = BeltFinder.findBelt(player);
        if (getter == null) {
            return;
        }
        ItemStack stack = getter.getBelt();
        if (stack.func_190916_E() <= 0) {
            return;
        }
        ItemStack inHand = player.func_184614_ca();
        if (!Config.isItemStackAllowed(inHand)) {
            return;
        }
        IItemHandlerModifiable cap = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (swapWith < 0) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)inHand, (boolean)false));
        } else {
            ItemStack inSlot = cap.getStackInSlot(swapWith);
            player.func_184611_a(EnumHand.MAIN_HAND, inSlot);
            cap.setStackInSlot(swapWith, inHand);
        }
        getter.syncToClients();
    }

    public static class Handler
    implements IMessageHandler<SwapItems, IMessage> {
        public IMessage onMessage(SwapItems message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = (WorldServer)player.field_70170_p;
            world.func_152344_a(() -> SwapItems.swapItem(message.swapWith, (EntityPlayer)player));
            return null;
        }
    }
}

