/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.VineBlock;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;

public class HoleTower
extends Tower {
    public HoleTower(WorldEditor worldEditor, Theme theme) {
        super(worldEditor, theme);
    }

    @Override
    public void generate(Coord origin) {
        BlockBrush blocks = this.getPrimaryWall();
        Coord floor = TowerType.getBaseCoord(this.editor, origin);
        Coord start = floor.copy().north().east().up(3);
        Coord end = origin.copy().south().west();
        SingleBlockBrush.AIR.fill(this.editor, RectSolid.newRect(start, end));
        start.north(2).east(2);
        end.south(2).west(2).up();
        RectSolid.newRect(start, end).fill(this.editor, this.getRubble(blocks), false, true).fill(this.editor, VineBlock.vine());
    }

    public BlockJumble getRubble(BlockBrush blocks) {
        BlockJumble rubble = new BlockJumble();
        rubble.addBlock(blocks);
        rubble.addBlock(SingleBlockBrush.AIR);
        rubble.addBlock(BlockType.DIRT.getBrush());
        rubble.addBlock(BlockType.DIRT_COARSE.getBrush());
        rubble.addBlock(BlockType.STONE_SMOOTH.getBrush());
        return rubble;
    }
}

