/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.dungeon.settings.DungeonSettingsParser;
import greymerk.roguelike.dungeon.settings.level.LevelsParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SegmentsParser {
    SegmentsParser() {
    }

    public static Map<Integer, SegmentGenerator> parseSegments(JsonElement segmentsElement) {
        if (!segmentsElement.isJsonArray()) {
            throw new DungeonSettingParseException("Expected field \"segments\" to contain a list of segments, but instead it was: " + segmentsElement.toString());
        }
        JsonArray segmentsArray = segmentsElement.getAsJsonArray();
        HashMap segmentsByLevel = Maps.newHashMap();
        for (JsonElement segmentElement : segmentsArray) {
            if (!segmentElement.isJsonObject()) {
                throw new DungeonSettingParseException("Expected list \"segments\" to contain segments, but instead it was: " + segmentElement.toString());
            }
            JsonObject segmentObject = segmentElement.getAsJsonObject();
            List<Integer> levels = LevelsParser.parseLevelsOrDefault(segmentObject, DungeonSettingsParser.ALL_LEVELS);
            for (Integer level : levels) {
                SegmentGenerator segmentGenerator = SegmentsParser.getSegmentGeneratorEnsuringly(level, segmentsByLevel);
                Segment segment = SegmentsParser.parseSegment(segmentObject);
                int weight = SegmentsParser.parseWeight(segmentObject);
                segmentGenerator.add(segment, weight);
            }
        }
        return segmentsByLevel;
    }

    public static SegmentGenerator getSegmentGeneratorEnsuringly(Integer level, Map<Integer, SegmentGenerator> segmentsByLevel) {
        if (!segmentsByLevel.containsKey(level)) {
            segmentsByLevel.put(level, new SegmentGenerator());
        }
        return segmentsByLevel.get(level);
    }

    public static boolean parseArch(JsonObject segmentObject, SegmentGenerator segmentGenerator) {
        if (segmentObject.has("arch")) {
            boolean a = segmentObject.get("arch").getAsBoolean();
            return true;
        }
        return false;
    }

    public static Segment parseSegment(JsonObject segmentObject) {
        return Segment.valueOf(segmentObject.get("type").getAsString());
    }

    public static int parseWeight(JsonObject segmentObject) {
        return segmentObject.has("weight") ? segmentObject.get("weight").getAsInt() : 1;
    }
}

