/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block.decorative;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.Plant;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;

public class FlowerPotBlock
extends SingleBlockBrush {
    private Plant content;

    public FlowerPotBlock() {
        super(BlockType.FLOWER_POT);
    }

    public FlowerPotBlock setContent(Plant content) {
        this.content = content;
        return this;
    }

    public Plant getContent() {
        return this.content;
    }

    public FlowerPotBlock withRandomContent(Random random) {
        return this.setContent(Plant.chooseRandom(random));
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord pos, boolean fillAir, boolean replaceSolid) {
        boolean succeeded = super.stroke(editor, pos, fillAir, replaceSolid);
        if (succeeded && this.content != null) {
            editor.setFlowerPotContent(pos, this.getContent());
        }
        return succeeded;
    }

    public static FlowerPotBlock flowerPot() {
        return new FlowerPotBlock();
    }

    @Override
    public FlowerPotBlock copy() {
        FlowerPotBlock copy = new FlowerPotBlock();
        copy.setFacing(this.getFacing());
        copy.setContent(this.content);
        return copy;
    }
}

