/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.Material;
import com.google.gson.JsonElement;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;

public class SingleBlockBrush
implements BlockBrush {
    public static final SingleBlockBrush AIR = BlockType.AIR.getBrush();
    private BlockType blockType;
    private Direction facing = Direction.EAST;
    private JsonElement json;
    private Material material;

    public SingleBlockBrush(BlockType blockType) {
        this(blockType, Material.NONE);
    }

    public SingleBlockBrush(BlockType blockType, Material material) {
        this.blockType = blockType;
        this.material = material;
    }

    public SingleBlockBrush(JsonElement jsonElement) throws DungeonSettingParseException {
        this.json = jsonElement;
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord pos, boolean fillAir, boolean replaceSolid) {
        return editor.setBlock(pos, this, fillAir, replaceSolid);
    }

    @Override
    public BlockBrush setFacing(Direction facing) {
        this.facing = facing;
        return this;
    }

    @Override
    public SingleBlockBrush copy() {
        SingleBlockBrush copy = new SingleBlockBrush(this.blockType, this.material);
        copy.setFacing(this.facing);
        copy.setJson(this.json);
        return copy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleBlockBrush)) {
            return false;
        }
        SingleBlockBrush other = (SingleBlockBrush)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockType this$blockType = this.getBlockType();
        BlockType other$blockType = other.getBlockType();
        if (this$blockType == null ? other$blockType != null : !((Object)((Object)this$blockType)).equals((Object)other$blockType)) {
            return false;
        }
        Direction this$facing = this.getFacing();
        Direction other$facing = other.getFacing();
        if (this$facing == null ? other$facing != null : !((Object)((Object)this$facing)).equals((Object)other$facing)) {
            return false;
        }
        JsonElement this$json = this.getJson();
        JsonElement other$json = other.getJson();
        if (this$json == null ? other$json != null : !this$json.equals(other$json)) {
            return false;
        }
        Material this$material = this.getMaterial();
        Material other$material = other.getMaterial();
        return !(this$material == null ? other$material != null : !((Object)((Object)this$material)).equals((Object)other$material));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleBlockBrush;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockType $blockType = this.getBlockType();
        result = result * 59 + ($blockType == null ? 43 : ((Object)((Object)$blockType)).hashCode());
        Direction $facing = this.getFacing();
        result = result * 59 + ($facing == null ? 43 : ((Object)((Object)$facing)).hashCode());
        JsonElement $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        Material $material = this.getMaterial();
        result = result * 59 + ($material == null ? 43 : ((Object)((Object)$material)).hashCode());
        return result;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public JsonElement getJson() {
        return this.json;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    public void setJson(JsonElement json) {
        this.json = json;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public String toString() {
        return "SingleBlockBrush(blockType=" + (Object)((Object)this.getBlockType()) + ", facing=" + (Object)((Object)this.getFacing()) + ", json=" + this.getJson() + ", material=" + (Object)((Object)this.getMaterial()) + ")";
    }
}

