/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.darknesslib;

import com.shinoow.darknesslib.api.DarknessLibAPI;
import com.shinoow.darknesslib.proxy.Proxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="darknesslib", name="DarknessLib", version="1.1.2", dependencies="required-after:forge@[14.23.5.2768,)", acceptedMinecraftVersions="[1.12.2]", guiFactory="com.shinoow.darknesslib.client.config.DarknessLibGuiFactory", updateJSON="https://raw.githubusercontent.com/Shinoow/DarknessLib/master/version.json", useMetadata=false, certificateFingerprint="220f10d3a93b3ff5fbaa7434cc629d863d6751b9")
public class DarknessLib {
    public static final String VERSION = "1.1.2";
    public static final String MODID = "darknesslib";
    public static final String NAME = "DarknessLib";
    @Mod.Metadata(value="darknesslib")
    public static ModMetadata METADATA;
    @Mod.Instance(value="darknesslib")
    public static DarknessLib INSTANCE;
    @SidedProxy(clientSide="com.shinoow.darknesslib.proxy.ClientProxy", serverSide="com.shinoow.darknesslib.proxy.CommonProxy")
    public static Proxy PROXY;
    public static Configuration CFG;
    public static String[] DYNAMIC_LIGHTS_LIST;
    public static boolean DYNAMIC_LIGHTS_MODE;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        METADATA = event.getModMetadata();
        this.getSupporterList();
        MinecraftForge.EVENT_BUS.register((Object)this);
        CFG = new Configuration(event.getSuggestedConfigurationFile());
        DarknessLib.syncConfig();
        PROXY.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit();
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.log(Level.WARN, "Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(m -> {
            Optional func;
            if (m.key.equals("addVehicle")) {
                if (m.isStringMessage()) {
                    try {
                        Class<?> clazz = Class.forName(m.getStringValue());
                        if (Entity.class.isAssignableFrom(clazz)) {
                            DarknessLibAPI.getInstance().addVehicle(clazz);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.ERROR, "Failed to add vehicle Class {} from {}: {}", (Object)m.getStringValue(), (Object)m.getSender(), (Object)e.getStackTrace());
                    }
                }
            } else if (m.key.equals("addLightsource")) {
                if (m.isStringMessage()) {
                    String[] data = m.getStringValue().split(";");
                    String[] stuff = data[0].split(":");
                    if (stuff.length <= 2) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stuff[0], stuff[1]));
                        if (item != null) {
                            DarknessLibAPI.getInstance().addLightsource(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE), data.length == 2 ? Integer.valueOf(data[1]) : 15);
                        } else {
                            LOGGER.log(Level.ERROR, "{} from {} is not a valid Item!", (Object)m.getStringValue(), (Object)m.getSender());
                        }
                    } else {
                        LOGGER.log(Level.ERROR, "{} from {} is not a valid Item!", (Object)m.getStringValue(), (Object)m.getSender());
                    }
                } else if (m.isItemStackMessage()) {
                    DarknessLibAPI.getInstance().addLightsource(m.getItemStackValue(), 15);
                }
            } else if (m.key.equals("addLighProvider") && m.isFunctionMessage() && (func = m.getFunctionValue(EntityPlayer.class, Integer.class)).isPresent()) {
                DarknessLibAPI.getInstance().addLightProvider((Function)func.get());
            }
        });
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            DarknessLib.syncConfig();
        }
    }

    private static void syncConfig() {
        DYNAMIC_LIGHTS_MODE = CFG.get("general", "Dynamic Lights Mode", false, "If this is enabled (client and server), handheld light sources will be treated as actual light while AtomicStryker's Dynamic Lights is present, or Optifine if its Dynamic Lights is enabled, or Smooth Entity Light is present.").getBoolean();
        DYNAMIC_LIGHTS_LIST = CFG.get("general", "Dynamic Lights List", new String[0], "Items/Blocks added to this list will be regarded as handheld light sources while AtomicStryker's Dynamic Lights is present, or Optifine if its Dynamic Lights is enabled (and Dynamic Lights Mode is enabled), or if Smooth Entity Light is present. Most light-emitting Blocks are automatically detected as light sources, so you might not have to add them to this list (check the log as it lists all that it finds)\nFormat: modid:name:meta;light_level, where meta and light_level are optional (light level is automatically set to 15 if not specified).\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getStringList();
        if (CFG.hasChanged()) {
            CFG.save();
        }
    }

    private void getSupporterList() {
        new Thread("DarknessLib Fetch Supporters"){

            @Override
            public void run() {
                String names = "";
                try {
                    BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
                    names = nameFile.readLine();
                    nameFile.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.ERROR, "Failed to fetch supporter list, using local version!");
                    names = "Jenni Mort, Simon.R.K";
                }
                DarknessLib.METADATA.description = DarknessLib.METADATA.description + String.format("\n\n\u00a76Supporters: %s\u00a7r", names);
            }
        }.start();
    }

    static {
        LOGGER = LogManager.getLogger((String)NAME);
    }
}

