/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.entities.projectiles.EntityFlyingSpear;
import com.mujmajnkraft.bettersurvival.items.ItemCustomWeapon;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpear
extends ItemCustomWeapon {
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("f14d3a86-ef0c-48a7-a59f-b6650e6132f5");
    private static final String REACH_MODIFIER_STRING = "bettersurvival:spear_reach";
    private final float reach;

    public ItemSpear(Item.ToolMaterial material) {
        super(material, ForgeConfigHandler.weapons.spearDmgMod, ForgeConfigHandler.weapons.spearSpd);
        this.setRegistryName("mujmajnkraftsbettersurvival", "item" + material.name().toLowerCase() + "spear");
        this.func_77655_b(material.name().toLowerCase() + "spear");
        this.field_77777_bU = 16;
        this.func_77656_e(0);
        this.reach = ForgeConfigHandler.weapons.spearReachBonus;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag = playerIn.field_71075_bZ.field_75098_d;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77973_b() instanceof ItemSpear || flag) {
            StatBase stats;
            float f = 1.0f;
            if (!worldIn.field_72995_K) {
                EntityFlyingSpear entityspear = new EntityFlyingSpear(worldIn, (EntityLivingBase)playerIn);
                ItemStack itemstack1 = itemstack.func_77946_l();
                itemstack1.func_190920_e(1);
                entityspear.setSpear(itemstack1);
                entityspear.setShooter((Entity)playerIn);
                entityspear.func_184547_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, f * 2.0f, 1.0f);
                ItemSpear spear = (ItemSpear)itemstack.func_77973_b();
                entityspear.func_70239_b(spear.getAttackDamage());
                entityspear.field_70251_a = flag ? EntityArrow.PickupStatus.CREATIVE_ONLY : EntityArrow.PickupStatus.ALLOWED;
                worldIn.func_72838_d((Entity)entityspear);
            }
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!flag) {
                playerIn.func_184586_b(handIn).func_190918_g(1);
            }
            if ((stats = StatList.func_188057_b((Item)this)) != null) {
                playerIn.func_71029_a(stats);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_MODIFIER_UUID, REACH_MODIFIER_STRING, (double)this.reach, 0));
        }
        return multimap;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return super.func_77644_a(stack, target, attacker);
    }

    public float breakChance() {
        return 32.0f / (float)this.getMaterial().func_77997_a();
    }

    public boolean func_77645_m() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String s = I18n.func_135052_a((String)"mujmajnkraftsbettersurvival.spear.desc", (Object[])new Object[0]);
        tooltip.add(TextFormatting.AQUA + s);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

