/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public final class IntermodUtils {
    private static final int DEFAULT_ENCHANTMENT_COLOR = -8372020;
    private static boolean getRuneColorCached = false;
    private static Method setTargetStackMethod = null;
    private static Method getColorMethod = null;

    private IntermodUtils() {
    }

    public static int getRuneColor(ItemStack stack) {
        if (!getRuneColorCached) {
            if (Loader.isModLoaded((String)"quark")) {
                try {
                    Class<?> clazz = Class.forName("vazkii.quark.misc.feature.ColorRunes");
                    setTargetStackMethod = clazz.getMethod("setTargetStack", ItemStack.class);
                    getColorMethod = Arrays.stream(clazz.getMethods()).filter(m -> "getColor".equals(m.getName())).findAny().orElse(null);
                }
                catch (ClassNotFoundException | NoSuchMethodException ex) {
                    WearableBackpacks.LOG.error("Error while fetching Quark ColorRunes methods", (Throwable)ex);
                }
            }
            getRuneColorCached = true;
        }
        if (setTargetStackMethod == null || getColorMethod == null) {
            return -8372020;
        }
        try {
            setTargetStackMethod.invoke(null, stack);
            return getColorMethod.getParameterCount() == 0 ? ((Integer)getColorMethod.invoke(null, new Object[0])).intValue() : ((Integer)getColorMethod.invoke(null, -8372020)).intValue();
        }
        catch (Exception ex) {
            WearableBackpacks.LOG.error("Error while invoking Quark ColorRunes methods", (Throwable)ex);
            setTargetStackMethod = null;
            getColorMethod = null;
            return -8372020;
        }
    }
}

