/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class DyeUtils {
    private static final Map<String, Integer> dyes = new HashMap<String, Integer>();

    private DyeUtils() {
    }

    public static int getDyeColor(ItemStack stack) {
        int[] oreIds;
        if (stack.func_190926_b()) {
            return -1;
        }
        for (int ore : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)ore);
            Integer color = dyes.get(name);
            if (color == null) continue;
            return color;
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        return DyeUtils.getDyeColor(stack) >= 0;
    }

    public static int getColorFromDyes(int color, Collection<ItemStack> dyes) {
        int number = dyes.size();
        if (number < 1) {
            return color;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        if (color >= 0) {
            r = color >> 16;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
            ++number;
        }
        for (ItemStack dye : dyes) {
            color = DyeUtils.getDyeColor(dye);
            if (color < 0) continue;
            r += color >> 16;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
        }
        return (r /= number) << 16 | (g /= number) << 8 | (b /= number);
    }

    public static int getColorFromDyes(Collection<ItemStack> dyes) {
        return DyeUtils.getColorFromDyes(-1, dyes);
    }

    static {
        String[] nameLookup = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String name = "dye" + nameLookup[color.func_176767_b()];
            float[] values = color.func_193349_f();
            int r = (int)(values[0] * 255.0f);
            int g = (int)(values[1] * 255.0f);
            int b = (int)(values[2] * 255.0f);
            dyes.put(name, r << 16 | g << 8 | b);
        }
    }
}

