/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class BackpackSize
implements INBTSerializable<NBTTagByteArray> {
    private static final Pattern PATTERN = Pattern.compile("^\\[([1-9]\\d?)x([1-9])\\]$");
    public static final BackpackSize MIN = new BackpackSize(1, 1);
    public static final BackpackSize MAX = new BackpackSize(17, 6);
    private int _columns = -1;
    private int _rows = -1;

    public int getColumns() {
        return this._columns;
    }

    public int getRows() {
        return this._rows;
    }

    public BackpackSize() {
    }

    public BackpackSize(int columns, int rows) {
        this._columns = columns;
        this._rows = rows;
    }

    public static BackpackSize parse(String str) {
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid backpack size value '" + str + "'");
        }
        int columns = Integer.parseInt(matcher.group(1));
        int rows = Integer.parseInt(matcher.group(2));
        if (columns > MAX.getColumns() || rows > MAX.getRows()) {
            throw new IllegalArgumentException("Backpack size value " + str + " over maximum (" + MAX + ")");
        }
        return new BackpackSize(columns, rows);
    }

    public static BackpackSize parse(NBTBase tag) {
        int rows;
        int columns;
        if (tag instanceof NBTTagByteArray) {
            NBTTagByteArray array = (NBTTagByteArray)tag;
            columns = array.func_150292_c()[0];
            rows = array.func_150292_c()[1];
        } else if (tag instanceof NBTTagIntArray) {
            NBTTagIntArray array = (NBTTagIntArray)tag;
            columns = array.func_150302_c()[0];
            rows = array.func_150302_c()[1];
        } else if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            columns = ((NBTPrimitive)list.func_179238_g(0)).func_150287_d();
            rows = ((NBTPrimitive)list.func_179238_g(1)).func_150287_d();
        } else {
            throw new RuntimeException("Invalid tag type " + NBTBase.field_82578_b[tag.func_74732_a()]);
        }
        return new BackpackSize(columns, rows);
    }

    public NBTTagByteArray serializeNBT() {
        return new NBTTagByteArray(new byte[]{(byte)this._columns, (byte)this._rows});
    }

    public void deserializeNBT(NBTTagByteArray nbt) {
        this._columns = nbt.func_150292_c()[0];
        this._rows = nbt.func_150292_c()[1];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BackpackSize)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BackpackSize size = (BackpackSize)obj;
        return size._columns == this._columns && size._rows == this._rows;
    }

    public String toString() {
        return "[" + this._columns + "x" + this._rows + "]";
    }
}

