/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix.filter;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.affix.filter.AffixFilter;
import c4.champions.common.util.JsonUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class AffixFilterManager {
    private static final Map<String, AffixFilter> FILTERS = Maps.newHashMap();
    private static final Map<String, Set<String>> ENTITY_AFFIX_MAP = Maps.newHashMap();

    @Nullable
    public static AffixFilter getAffixFilter(String identifier) {
        return FILTERS.get(identifier);
    }

    public static boolean hasAffixFilter(String identifier) {
        return AffixFilterManager.getAffixFilter(identifier) != null;
    }

    public static boolean isValidAffix(AffixBase affix, EntityLiving entityLiving, int tier) {
        boolean hasTier;
        AffixFilter filter = AffixFilterManager.getAffixFilter(affix.getIdentifier());
        boolean bl = hasTier = affix.getTier() <= tier;
        if (filter != null) {
            hasTier = filter.getTier() <= tier;
            return filter.isEnabled() && hasTier && !AffixFilterManager.isEntityBlacklisted(filter, (Entity)entityLiving);
        }
        return hasTier;
    }

    public static boolean isEntityBlacklisted(@Nonnull AffixFilter filter, Entity entity) {
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (rl != null) {
            for (String key : filter.getEntityBlacklist()) {
                if (!key.equals(rl.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static Set<String> getPresetAffixesForEntity(Entity entity) {
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        return rl != null ? ENTITY_AFFIX_MAP.getOrDefault(rl.toString(), Sets.newHashSet()) : Sets.newHashSet();
    }

    public static void readAffixFiltersFromJson() {
        AffixFilter[] filters;
        for (AffixFilter filter : filters = JsonUtil.fromJson((TypeToken<T[]>)TypeToken.get(AffixFilter[].class), new File(Loader.instance().getConfigDir(), "champions/affixes.json"), AffixFilterManager.buildDefaultAffixFilters())) {
            FILTERS.put(filter.getIdentifier(), filter);
            String[] alwaysOn = filter.getAlwaysOnEntity();
            if (alwaysOn.length <= 0) continue;
            for (String entityName : alwaysOn) {
                Set<String> affixes = ENTITY_AFFIX_MAP.getOrDefault(entityName, Sets.newHashSet());
                affixes.add(filter.getIdentifier());
                ENTITY_AFFIX_MAP.putIfAbsent(entityName, affixes);
            }
        }
    }

    private static AffixFilter[] buildDefaultAffixFilters() {
        ImmutableList<AffixBase> affixes = AffixRegistry.getAllAffixes();
        ArrayList filters = Lists.newArrayList();
        for (AffixBase aff : affixes) {
            filters.add(new AffixFilter(aff.getIdentifier(), true, new String[0], new String[0], aff.getTier()));
        }
        AffixFilter[] arr = new AffixFilter[filters.size()];
        return filters.toArray(arr);
    }
}

