/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix.core;

import c4.champions.Champions;
import c4.champions.common.capability.IChampionship;
import c4.champions.network.NetworkHandler;
import c4.champions.network.PacketSyncAffix;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public abstract class AffixNBT {
    private IChampionship championship;
    private String identifier;

    protected AffixNBT() {
    }

    public void readData(IChampionship championship, String identifier) {
        this.championship = championship;
        this.identifier = identifier;
        this.readFromNBT(championship.getAffixData(identifier));
    }

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract NBTTagCompound writeToNBT();

    public void saveData(EntityLiving living) {
        this.championship.setAffixData(this.identifier, this.writeToNBT());
        this.syncToTracking(living);
    }

    private void syncToTracking(EntityLiving living) {
        if (living.field_70170_p instanceof WorldServer) {
            WorldServer world = (WorldServer)living.field_70170_p;
            for (EntityPlayer player : world.func_73039_n().getTrackingPlayers((Entity)living)) {
                if (!(player instanceof EntityPlayerMP) || this.championship.getRank() == null) continue;
                NetworkHandler.INSTANCE.sendTo((IMessage)new PacketSyncAffix(living.func_145782_y(), this.championship.getRank().getTier(), (Map<String, NBTTagCompound>)this.championship.getAffixData(), this.championship.getName()), (EntityPlayerMP)player);
            }
        }
    }

    public static <T extends AffixNBT> T getData(@Nonnull IChampionship championship, String affix, Class<T> clazz) {
        AffixNBT data = null;
        try {
            data = (AffixNBT)clazz.newInstance();
            data.readData(championship, affix);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Champions.logger.log(Level.ERROR, "Error reading data from class " + clazz.toString());
        }
        return (T)data;
    }

    public static class Integer
    extends AffixNBT {
        public int num;

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.num = tag.func_74762_e("num");
        }

        @Override
        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("num", this.num);
            return compound;
        }
    }

    public static class Text
    extends AffixNBT {
        public String text;

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.text = tag.func_74779_i("text");
        }

        @Override
        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("text", this.text);
            return compound;
        }
    }

    public static class Boolean
    extends AffixNBT {
        public boolean mode;

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.mode = tag.func_74767_n("mode");
        }

        @Override
        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("mode", this.mode);
            return compound;
        }
    }
}

