/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.client;

import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientUtil {
    private static final Minecraft client = FMLClientHandler.instance().getClient();
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation GUI_STAR = new ResourceLocation("champions", "textures/gui/staricon.png");

    public static RayTraceResult getMouseOver(float partialTicks, float distance) {
        Entity entity = client.func_175606_aa();
        if (entity != null && ClientUtil.client.field_71441_e != null) {
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            Vec3d vec3d1 = entity.func_70676_i(partialTicks);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance);
            RayTraceResult objectMouseOver = ClientUtil.rayTraceBlocks(entity.field_70170_p, vec3d, vec3d2, false, false, true);
            int i = 3;
            double d1 = distance;
            if (objectMouseOver != null) {
                d1 = objectMouseOver.field_72307_f.func_72438_d(vec3d);
            }
            Entity pointedEntity = null;
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List list = ClientUtil.client.field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, entity1 -> entity1 != null && entity1.func_70067_L()));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity12 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity12.func_174813_aQ().func_186662_g((double)entity12.func_70111_Y() + 0.5);
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity12;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity12.func_184208_bv() == entity.func_184208_bv() && !entity12.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity12;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                pointedEntity = entity12;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && vec3d.func_72438_d(vec3d3) > (double)distance) {
                pointedEntity = null;
                objectMouseOver = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, EnumFacing.UP, new BlockPos(vec3d3));
            }
            if (pointedEntity != null && (d2 < d1 || objectMouseOver == null)) {
                objectMouseOver = new RayTraceResult(pointedEntity, vec3d3);
            }
            return objectMouseOver;
        }
        return null;
    }

    public static void renderChampionHealth(EntityLiving living, IChampionship chp) {
        int startX;
        ScaledResolution scaledresolution = new ScaledResolution(client);
        int i = scaledresolution.func_78326_a();
        int k = i / 2 - 91;
        int j = 21;
        int xOffset = ConfigHandler.client.xOffset;
        int yOffset = ConfigHandler.client.yOffset;
        int color = chp.getRank().getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        boolean renderName = ConfigHandler.client.nameVisibility;
        if (!renderName) {
            yOffset -= 10;
        }
        client.func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
        ClientUtil.render(xOffset + k, yOffset + j, living.func_110143_aJ() / living.func_110138_aP());
        client.func_110434_K().func_110577_a(GUI_STAR);
        int num = chp.getRank().getTier();
        if (!renderName) {
            yOffset += 10;
        }
        if (num <= 18) {
            startX = xOffset + i / 2 - 5 - 5 * (num - 1);
            for (int tier = 0; tier < num; ++tier) {
                Gui.func_146110_a((int)startX, (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
                startX += 10;
            }
        } else {
            startX = xOffset + i / 2 - 5;
            String count = "x" + num;
            Gui.func_146110_a((int)(startX - ClientUtil.client.field_71466_p.func_78256_a(count) / 2), (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            ClientUtil.client.field_71466_p.func_175063_a(count, (float)(startX + 10) - (float)ClientUtil.client.field_71466_p.func_78256_a(count) / 2.0f, 2.0f, 0xFFFFFF);
        }
        if (renderName) {
            String s = living.func_145818_k_() ? living.func_145748_c_().func_150254_d() : chp.getName();
            ClientUtil.client.field_71466_p.func_175063_a(s, (float)xOffset + (float)(i / 2 - ClientUtil.client.field_71466_p.func_78256_a(s) / 2), (float)yOffset + (float)(j - 9), color);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringBuilder builder = new StringBuilder();
        if (!renderName) {
            yOffset -= 10;
        }
        for (String aff : chp.getAffixes()) {
            builder.append(I18n.func_135052_a((String)("champions.affix." + aff), (Object[])new Object[0]));
            builder.append(" ");
        }
        String affixes = builder.toString().trim();
        ClientUtil.client.field_71466_p.func_175063_a(affixes, (float)xOffset + (float)(i / 2 - ClientUtil.client.field_71466_p.func_78256_a(affixes) / 2), (float)yOffset + (float)(j + 6), 0xFFFFFF);
        GlStateManager.func_179084_k();
    }

    private static void render(int x, int y, float percentHealth) {
        ClientUtil.drawTexturedModalRect(x, y, 0, 60, 182, 5);
        int i = (int)(percentHealth * 183.0f);
        if (i > 0) {
            ClientUtil.drawTexturedModalRect(x, y, 0, 65, i, 5);
        }
    }

    private static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float u = 0.00390625f;
        float v = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * u), (double)((float)(textureY + height) * v)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * u), (double)((float)(textureY + height) * v)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) * u), (double)((float)textureY * v)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * u), (double)((float)textureY * v)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_180664_k() == BlockRenderLayer.SOLID && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_180664_k() == BlockRenderLayer.SOLID && block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

