/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.api.recipes.IRecipeManager;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeShaped;
import crafttweaker.mc1120.recipes.MCRecipeShapeless;
import crafttweaker.mc1120.recipes.MCRecipeWrapper;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.Optional;

public final class MCRecipeManager
implements IRecipeManager {
    public static final List<ActionBaseAddRecipe> recipesToAdd = new ArrayList<ActionBaseAddRecipe>();
    public static final List<ActionBaseRemoveRecipes> recipesToRemove = new ArrayList<ActionBaseRemoveRecipes>();
    public static final ActionRemoveRecipesNoIngredients actionRemoveRecipesNoIngredients = new ActionRemoveRecipesNoIngredients();
    public static Set<Map.Entry<ResourceLocation, IRecipe>> recipes;
    public static final List<MCRecipeBase> transformerRecipes;
    public static final List<MCRecipeBase> actionRecipes;
    private static final TIntSet usedHashes;
    private static final HashSet<String> usedRecipeNames;

    private static boolean matchesItem(ItemStack input, IIngredient ingredient) {
        return ingredient == null ? input.func_190926_b() : !input.func_190926_b() && ingredient.matches(CraftTweakerMC.getIItemStackForMatching(input));
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input instanceof String) {
            return ingredient.contains(CraftTweakerMC.getOreDict((String)input));
        }
        if (input instanceof ItemStack) {
            return MCRecipeManager.matchesItem((ItemStack)input, ingredient);
        }
        if (input instanceof Ingredient) {
            ItemStack[] matchingStacks = ((Ingredient)input).func_193365_a();
            return matchingStacks.length > 0 && MCRecipeManager.matchesItem(matchingStacks[0], ingredient);
        }
        return false;
    }

    @Deprecated
    public static String saveToString(Object ingredient) {
        if (ingredient == null) {
            return "_";
        }
        return ingredient.toString();
    }

    @Deprecated
    public static String saveToString(IIngredient ingredient) {
        return MCRecipeManager.saveToString((Object)ingredient);
    }

    public static String cleanRecipeName(String s) {
        if (s.contains(":")) {
            CraftTweakerAPI.logWarning("Recipe name [" + s + "] may not contain a ':', replacing with '_'!");
        }
        return s.replace(":", "_");
    }

    public static void refreshRecipes() {
        recipes = ForgeRegistries.RECIPES.getEntries();
    }

    public static void cleanUpRecipeList() {
        Iterator<ActionBaseAddRecipe> iterator = recipesToAdd.iterator();
        while (iterator.hasNext()) {
            ActionBaseAddRecipe next = iterator.next();
            MCRecipeBase recipe = next.getRecipe();
            if (recipe == null) {
                CraftTweakerAPI.logWarning("Recipe action " + next.getClass().getCanonicalName() + " had null recipe, please report this issue!");
                continue;
            }
            if (ForgeRegistries.RECIPES.containsKey(recipe.getRegistryName())) continue;
            CraftTweakerAPI.logWarning("Recipe " + recipe.toCommandString() + " was created but not added to the Recipe Registry, check for other errors in your log!");
            iterator.remove();
        }
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        if (recipes == null) {
            recipes = ForgeRegistries.RECIPES.getEntries();
        }
        for (Map.Entry<ResourceLocation, IRecipe> ent : recipes) {
            ItemStack stack = ent.getValue().func_77571_b();
            if (stack.func_190926_b() || !ingredient.matches(CraftTweakerMC.getIItemStackForMatching(stack))) continue;
            if (ent.getValue() instanceof MCRecipeBase) {
                results.add((MCRecipeBase)ent.getValue());
                continue;
            }
            results.add(new MCRecipeWrapper(ent.getValue()));
        }
        return results;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        if (recipes == null) {
            recipes = ForgeRegistries.RECIPES.getEntries();
        }
        for (Map.Entry<ResourceLocation, IRecipe> recipeEntry : recipes) {
            IRecipe recipe = recipeEntry.getValue();
            if (recipe instanceof MCRecipeBase) {
                results.add((MCRecipeBase)recipe);
                continue;
            }
            results.add(new MCRecipeWrapper(recipe));
        }
        return results;
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, false, false));
    }

    @Override
    public void addShaped(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, false, false));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, true, false));
    }

    @Override
    public void addShapedMirrored(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, true, false));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        if (this.checkShapelessNulls(output, ingredients)) {
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(output, ingredients, function, action));
    }

    @Override
    public void addShapeless(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        if (this.checkShapelessNulls(output, ingredients)) {
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(name, output, ingredients, function, action, false));
    }

    @Override
    public void addHiddenShapeless(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        if (this.checkShapelessNulls(output, ingredients)) {
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(name, output, ingredients, function, action, true));
    }

    private boolean checkShapelessNulls(IItemStack output, IIngredient[] ingredients) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
            break;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return true;
        }
        return false;
    }

    @Override
    public void addHiddenShaped(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action, @Optional boolean mirrored) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, mirrored, true));
    }

    @Override
    public void removeAll() {
        recipesToRemove.add(new ActionRemoveAllRecipes());
    }

    @Override
    public void remove(IIngredient output, @Optional boolean nbtMatch) {
        if (output == null) {
            CraftTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        actionRemoveRecipesNoIngredients.addOutput(output, nbtMatch);
    }

    @Override
    public void removeByRecipeName(String recipeName, @Optional IItemStack outputFilter) {
        recipesToRemove.add(new ActionRemoveRecipeByRecipeName(recipeName, outputFilter));
    }

    @Override
    public void removeByRegex(String regexString, @Optional IItemStack outputFilter) {
        recipesToRemove.add(new ActionRemoveRecipeByRegex(regexString, outputFilter));
    }

    @Override
    public void removeByMod(String modid) {
        recipesToRemove.add(new ActionRemoveRecipeByMod(modid));
    }

    @Override
    public void removeShaped(IIngredient output, IIngredient[][] ingredients) {
        if (output == null) {
            CraftTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        recipesToRemove.add(new ActionRemoveShapedRecipes(output, ingredients));
    }

    @Override
    public void removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        if (output == null) {
            CraftTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        recipesToRemove.add(new ActionRemoveShapelessRecipes(output, ingredients, wildcard));
    }

    @Override
    public void removeByInput(IIngredient input) {
        if (input == null) {
            CraftTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        recipesToRemove.add(new ActionRemoveRecipesByInput(input));
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        Object[] iContents = new ItemStack[width * height];
        Arrays.fill(iContents, ItemStack.field_190927_a);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = CraftTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.func_70299_a(i, (ItemStack)iContents[i]);
        }
        ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)inventory, null);
        if (result.func_190926_b()) {
            return null;
        }
        return CraftTweakerMC.getIItemStack(result);
    }

    @Override
    public void replaceAllOccurences(IIngredient toReplace, IIngredient replaceWith, IIngredient forOutput) {
        ActionReplaceAllOccurences.INSTANCE.addSubAction(new SubActionReplaceAllOccurences(toReplace, replaceWith, forOutput));
    }

    static {
        transformerRecipes = new ArrayList<MCRecipeBase>();
        actionRecipes = new ArrayList<MCRecipeBase>();
        usedHashes = new TIntHashSet();
        usedRecipeNames = new HashSet();
    }

    private static class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }

    public static enum ActionReplaceAllOccurences implements IAction
    {
        INSTANCE;

        private SubActionReplaceAllOccurences first;
        private SubActionReplaceAllOccurences last;
        private ICraftingRecipe currentModifiedRecipe;
        private IIngredient[] ingredients1D;
        private IIngredient[][] ingredients2D;
        private boolean recipeModified = false;
        private final List<ActionRemoveRecipeByRecipeName> toRemoveRecipe = new ArrayList<ActionRemoveRecipeByRecipeName>();

        public void setCurrentModifiedRecipe(ICraftingRecipe currentModifiedRecipe) {
            if (currentModifiedRecipe == null || currentModifiedRecipe.getOutput() == null) {
                return;
            }
            this.currentModifiedRecipe = currentModifiedRecipe;
            if (currentModifiedRecipe.isShaped()) {
                this.ingredients2D = currentModifiedRecipe.getIngredients2D();
            } else {
                this.ingredients1D = currentModifiedRecipe.getIngredients1D();
            }
        }

        public void addSubAction(SubActionReplaceAllOccurences subAction) {
            if (this.first == null) {
                this.first = subAction;
            }
            if (this.last != null) {
                this.last.next = subAction;
            }
            this.last = subAction;
        }

        public boolean hasSubAction() {
            return this.first != null;
        }

        public void clear() {
            this.last = null;
            this.first = null;
            this.toRemoveRecipe.clear();
        }

        @Override
        public void apply() {
            if (this.currentModifiedRecipe == null) {
                return;
            }
            SubActionReplaceAllOccurences current = this.first;
            while (current != null) {
                current.apply();
                current = current.next;
            }
            if (this.recipeModified) {
                this.toRemoveRecipe.add(new ActionRemoveRecipeByRecipeName(this.currentModifiedRecipe.getFullResourceName(), null));
                String name = this.currentModifiedRecipe.getResourceDomain() + "_" + this.currentModifiedRecipe.getName() + "_modified";
                IItemStack out = this.currentModifiedRecipe.getOutput();
                if (this.currentModifiedRecipe.isShaped()) {
                    CraftTweakerAPI.recipes.addShaped(name, out, this.ingredients2D, null, null);
                } else {
                    CraftTweakerAPI.recipes.addShapeless(name, out, this.ingredients1D, null, null);
                }
            }
            this.currentModifiedRecipe = null;
            this.ingredients1D = null;
            this.ingredients2D = null;
            this.recipeModified = false;
        }

        public void describeSubActions() {
            SubActionReplaceAllOccurences current = this.first;
            while (current != null) {
                CraftTweakerAPI.logInfo(current.describe());
                current = current.next;
            }
        }

        public void removeOldRecipes() {
            CraftTweaker.INSTANCE.applyActions(this.toRemoveRecipe, "Removing old recipes for replace occurrences action", "Failed to remove old recipes for replace occurrences action");
        }

        @Override
        public String describe() {
            return null;
        }

        static /* synthetic */ IIngredient[] access$702(ActionReplaceAllOccurences x0, IIngredient[] x1) {
            x0.ingredients1D = x1;
            return x1;
        }
    }

    public static class SubActionReplaceAllOccurences
    implements IAction {
        private SubActionReplaceAllOccurences next;
        private final IIngredient toReplace;
        private final IIngredient replaceWith;
        private final IIngredient forOutput;

        public SubActionReplaceAllOccurences(IIngredient toReplace, IIngredient replaceWith, IIngredient forOutput) {
            this.toReplace = toReplace == null ? MCItemStack.EMPTY : toReplace;
            this.replaceWith = replaceWith;
            this.forOutput = forOutput;
        }

        @Override
        public void apply() {
            if (ActionReplaceAllOccurences.INSTANCE.currentModifiedRecipe == null) {
                return;
            }
            if (this.forOutput == null || this.forOutput.contains(ActionReplaceAllOccurences.INSTANCE.currentModifiedRecipe.getOutput())) {
                this.applyShapedPattern();
                this.applyShapelessPattern();
            }
        }

        @Override
        public String describe() {
            String replaceWithName = this.replaceWith == null ? MCItemStack.EMPTY.toString() : this.replaceWith.toString();
            return "Removing all occurences of ingredient: " + this.toReplace + " and replacing them with " + replaceWithName;
        }

        private IIngredient changeIngredient(@Nullable IIngredient input) {
            if (input == null) {
                return this.toReplace == MCItemStack.EMPTY ? this.replaceWith : null;
            }
            List<IItemStack> inputItems = input.getItems();
            if (inputItems == null) {
                return input;
            }
            if (inputItems.size() == 1) {
                if (this.toReplace.matches(inputItems.get(0))) {
                    return this.replaceWith;
                }
            } else if (inputItems.size() > 1) {
                if (inputItems.removeIf(this.toReplace::matches)) {
                    if (inputItems.isEmpty()) {
                        return this.replaceWith;
                    }
                    IngredientOr temp = new IngredientOr(inputItems.toArray(new IIngredient[0]));
                    return this.replaceWith == null ? temp : temp.or(this.replaceWith);
                }
            }
            return input;
        }

        private void applyShapelessPattern() {
            if (ActionReplaceAllOccurences.INSTANCE.ingredients1D != null) {
                boolean replaceWithAir = false;
                for (int i = 0; i < ActionReplaceAllOccurences.INSTANCE.ingredients1D.length; ++i) {
                    IIngredient ingredient = ActionReplaceAllOccurences.INSTANCE.ingredients1D[i];
                    IIngredient changeResult = this.changeIngredient(ingredient);
                    if (changeResult == null) {
                        replaceWithAir = true;
                    }
                    if (changeResult == ingredient) continue;
                    ((ActionReplaceAllOccurences)ActionReplaceAllOccurences.INSTANCE).ingredients1D[i] = changeResult;
                    ActionReplaceAllOccurences.INSTANCE.recipeModified = true;
                }
                if (replaceWithAir) {
                    ActionReplaceAllOccurences.access$702(ActionReplaceAllOccurences.INSTANCE, (IIngredient[])ArrayUtils.removeAllOccurences((Object[])ActionReplaceAllOccurences.INSTANCE.ingredients1D, null));
                }
            }
        }

        private void applyShapedPattern() {
            if (ActionReplaceAllOccurences.INSTANCE.ingredients2D != null) {
                for (int i = 0; i < ActionReplaceAllOccurences.INSTANCE.ingredients2D.length; ++i) {
                    for (int j = 0; j < ActionReplaceAllOccurences.INSTANCE.ingredients2D[i].length; ++j) {
                        IIngredient ingredient = ActionReplaceAllOccurences.INSTANCE.ingredients2D[i][j];
                        IIngredient changeResult = this.changeIngredient(ingredient);
                        if (changeResult == ingredient) continue;
                        ((ActionReplaceAllOccurences)ActionReplaceAllOccurences.INSTANCE).ingredients2D[i][j] = changeResult;
                        ActionReplaceAllOccurences.INSTANCE.recipeModified = true;
                    }
                }
            }
        }
    }

    private static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapelessRecipe(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
            this(null, output, ingredients, function, action, false);
        }

        public ActionAddShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action, boolean hidden) {
            super(new MCRecipeShapeless(ingredients, output, function, action, hidden), output, false);
            this.setName(name);
        }
    }

    private static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            this(null, output, ingredients, function, action, mirrored, hidden);
        }

        public ActionAddShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            super(new MCRecipeShaped(ingredients, output, function, action, mirrored, hidden), output, true);
            this.setName(name);
        }
    }

    public static class ActionBaseAddRecipe
    implements IAction {
        protected MCRecipeBase recipe;
        protected IItemStack output;
        protected boolean isShaped;
        protected String name;

        @Deprecated
        public ActionBaseAddRecipe() {
        }

        private ActionBaseAddRecipe(MCRecipeBase recipe, IItemStack output, boolean isShaped) {
            this.recipe = recipe;
            this.output = output;
            this.isShaped = isShaped;
            if (recipe.hasTransformers()) {
                transformerRecipes.add(recipe);
            }
            if (recipe.hasRecipeAction()) {
                actionRecipes.add(recipe);
            }
        }

        public IItemStack getOutput() {
            return this.output;
        }

        public void setOutput(IItemStack output) {
            this.output = output;
        }

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            if (name != null) {
                String proposedName = MCRecipeManager.cleanRecipeName(name);
                if (usedRecipeNames.contains(proposedName)) {
                    this.name = this.calculateName();
                    CraftTweakerAPI.logWarning("Recipe name [" + name + "] has duplicate uses, defaulting to calculated hash!");
                } else {
                    this.name = proposedName;
                }
            } else {
                this.name = this.calculateName();
            }
            usedRecipeNames.add(this.name);
        }

        public String calculateName() {
            int hash = this.recipe.toCommandString().hashCode();
            while (usedHashes.contains(hash)) {
                ++hash;
            }
            usedHashes.add(hash);
            return (this.isShaped ? "ct_shaped" : "ct_shapeless") + hash;
        }

        @Override
        public void apply() {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)this.recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Adding " + (this.isShaped ? "shaped" : "shapeless") + " recipe for " + this.output.getDisplayName() + " with name " + this.name;
            }
            return "Trying to add " + (this.isShaped ? "shaped" : "shapeless") + "recipe without correct output";
        }

        public MCRecipeBase getRecipe() {
            return this.recipe;
        }
    }

    public static class ActionRemoveRecipesByInput
    extends ActionBaseRemoveRecipes {
        private final IIngredient ingredient;

        public ActionRemoveRecipesByInput(IIngredient ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block0: for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                for (Ingredient ingredient : recipe.getValue().func_192400_c()) {
                    if (!MCRecipeManager.matches(ingredient, this.ingredient)) continue;
                    toRemove.add(recipe.getKey());
                    continue block0;
                }
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing recipes for " + this.ingredient + " input";
        }
    }

    public static class ActionRemoveAllRecipes
    extends ActionBaseRemoveRecipes {
        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing all crafting recipes";
        }
    }

    public static class ActionRemoveRecipeByRegex
    extends ActionBaseRemoveRecipes {
        String regexCheck;
        IItemStack filter;

        public ActionRemoveRecipeByRegex(String regexCheck, IItemStack filter) {
            this.regexCheck = regexCheck;
            this.filter = filter;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            Pattern p = Pattern.compile(this.regexCheck);
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                ResourceLocation resourceLocation = recipe.getKey();
                Matcher m = p.matcher(resourceLocation.toString());
                if (!m.matches()) continue;
                if (this.filter != null) {
                    if (!this.filter.matches(CraftTweakerMC.getIItemStackForMatching(recipe.getValue().func_77571_b()))) continue;
                    toRemove.add(recipe.getKey());
                    continue;
                }
                toRemove.add(resourceLocation);
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.regexCheck != null) {
                if (this.filter != null) {
                    return "Removing all recipes matching this regex: \"" + this.regexCheck + "\", Matching filter: " + this.filter.getDisplayName();
                }
                return "Removing all recipes matching this regex: \"" + this.regexCheck + "\"";
            }
            return "No regex String for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipeByMod
    extends ActionBaseRemoveRecipes {
        String modid;

        public ActionRemoveRecipeByMod(String modid) {
            this.modid = modid;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (!recipe.getKey().func_110624_b().equalsIgnoreCase(this.modid)) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing recipes matching: " + this.modid;
        }
    }

    public static class ActionRemoveRecipeByRecipeName
    extends ActionBaseRemoveRecipes {
        String recipeName;
        IItemStack filter;

        public ActionRemoveRecipeByRecipeName(String recipeName, IItemStack filter) {
            this.recipeName = recipeName;
            this.filter = filter;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (!recipe.getKey().toString().equals(this.recipeName)) continue;
                if (this.filter != null) {
                    if (!this.filter.matches(CraftTweakerMC.getIItemStackForMatching(recipe.getValue().func_77571_b()))) break;
                    toRemove.add(recipe.getKey());
                    break;
                }
                toRemove.add(recipe.getKey());
                break;
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.recipeName != null) {
                if (this.filter != null) {
                    return "Removing recipe with name \"" + this.recipeName + "\", Matching filter: " + this.filter.getDisplayName();
                }
                return "Removing recipe with name \"" + this.recipeName + "\"";
            }
            return "No name for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipesNoIngredients
    extends ActionBaseRemoveRecipes {
        private final List<Pair<IIngredient, Boolean>> outputs = new ArrayList<Pair<IIngredient, Boolean>>();

        public void addOutput(IIngredient output, @Optional boolean nbtMatch) {
            this.outputs.add((Pair<IIngredient, Boolean>)Pair.of((Object)output, (Object)nbtMatch));
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                ItemStack recipeOutput = recipe.getValue().func_77571_b();
                IItemStack stack = CraftTweakerMC.getIItemStackForMatching(recipeOutput);
                if (stack == null || !this.matches(stack)) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        private boolean matches(IItemStack stack) {
            for (Pair<IIngredient, Boolean> entry : this.outputs) {
                IIngredient output = (IIngredient)entry.getKey();
                Boolean nbtMatch = (Boolean)entry.getValue();
                if (!(nbtMatch != false ? output.matchesExact(stack) : output.matches(stack))) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describe() {
            return "Removing recipes for various outputs";
        }
    }

    public static class ActionRemoveShapelessRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[] ingredients;
        boolean wildcard;

        public ActionRemoveShapelessRecipes(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
            this.output = output;
            this.ingredients = ingredients;
            this.wildcard = wildcard;
        }

        @Override
        public void apply() {
            if (this.output == null) {
                return;
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block0: for (Map.Entry<ResourceLocation, IRecipe> entry : recipes) {
                IRecipe recipe = entry.getValue();
                if (entry.getValue().func_77571_b().func_190926_b() || !this.output.matches(CraftTweakerMC.getIItemStackForMatching(entry.getValue().func_77571_b())) || recipe instanceof IShapedRecipe || !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
                if (this.ingredients != null) {
                    ShapelessRecipes srecipe;
                    if (recipe instanceof ShapelessRecipes) {
                        srecipe = (ShapelessRecipes)recipe;
                        if (this.ingredients.length > srecipe.func_192400_c().size() || !this.wildcard && this.ingredients.length < srecipe.func_192400_c().size()) continue;
                        block1: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(srecipe.field_77579_b.get(k), ingredient)) continue block1;
                            }
                            continue block0;
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        srecipe = (ShapelessOreRecipe)recipe;
                        NonNullList inputs = srecipe.func_192400_c();
                        if (inputs.size() < this.ingredients.length || !this.wildcard && inputs.size() > this.ingredients.length) continue;
                        block3: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(inputs.get(k), ingredient)) continue block3;
                            }
                            continue block0;
                        }
                    }
                }
                toRemove.add(entry.getKey());
            }
            CraftTweakerAPI.logInfo("Removing " + toRemove.size() + " Shapeless recipes.");
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shapeless recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static class ActionRemoveShapedRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[][] ingredients;

        public ActionRemoveShapedRecipes(IIngredient output, IIngredient[][] ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }

        @Override
        public void apply() {
            int ingredientsWidth = 0;
            int ingredientsHeight = 0;
            if (this.ingredients != null) {
                ingredientsHeight = this.ingredients.length;
                for (IIngredient[] ingredient : this.ingredients) {
                    ingredientsWidth = Math.max(ingredientsWidth, ingredient.length);
                }
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block1: for (Map.Entry<ResourceLocation, IRecipe> recipeEntry : recipes) {
                IRecipe recipe = recipeEntry.getValue();
                ItemStack output = recipe.func_77571_b();
                if (output.func_190926_b() || !this.output.matches(CraftTweakerMC.getIItemStackForMatching(output)) || !(recipe instanceof IShapedRecipe)) continue;
                if (this.ingredients != null) {
                    IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
                    int width = shapedRecipe.getRecipeWidth();
                    int height = shapedRecipe.getRecipeHeight();
                    if (ingredientsWidth != width || ingredientsHeight != height) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = this.ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient = k > row.length ? null : row[k];
                            Ingredient ing = (Ingredient)shapedRecipe.func_192400_c().get(j * width + k);
                            ItemStack input = ing == Ingredient.field_193370_a || ing.test((Object)ItemStack.field_190927_a) || ing.func_193365_a().length == 0 ? ItemStack.field_190927_a : ing.func_193365_a()[0];
                            if (!MCRecipeManager.matchesItem(input, ingredient)) continue block1;
                        }
                    }
                    toRemove.add(recipeEntry.getKey());
                    continue;
                }
                toRemove.add(recipeEntry.getKey());
            }
            CraftTweakerAPI.logInfo(toRemove.size() + " removed");
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shaped recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static abstract class ActionBaseRemoveRecipes
    implements IAction {
        public void removeRecipes(List<ResourceLocation> removingRecipes) {
            removingRecipes.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
        }
    }
}

