/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.util;

import com.elenai.elenaidodge.ElenaiDodge;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="elenaidodge")
public class PatronRewardHandler {
    private static final ImmutableSet<String> DEV_UUID = ImmutableSet.of((Object)"1f12bbe0-0396-458e-8bb6-49bffdeb46dd", (Object)"2436164d-96a1-4fe8-8c0c-a118ff2d9157", (Object)"c4c40239-2e88-42d3-a5bb-806ed8c21845", (Object)"5084e6f3-8f54-43f1-8df5-1dca109e430f");
    private static final Set<String> done = Collections.newSetFromMap(new WeakHashMap());
    private static Thread thread;
    private static String name;
    private static final Map<String, Integer> tiers;
    public static int localPatronTier;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        AbstractClientPlayer clientPlayer;
        EntityPlayer player = event.getEntityPlayer();
        String uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
        if (player instanceof AbstractClientPlayer && DEV_UUID.contains((Object)uuid) && !done.contains(uuid) && (clientPlayer = (AbstractClientPlayer)player).func_152122_n()) {
            NetworkPlayerInfo info = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)clientPlayer, (String)"field_175157_a");
            Map textures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)info, (String)"field_187107_a");
            ResourceLocation loc = new ResourceLocation("elenaidodge", "textures/misc/dev_cape.png");
            textures.put(MinecraftProfileTexture.Type.CAPE, loc);
            textures.put(MinecraftProfileTexture.Type.ELYTRA, loc);
            done.add(uuid);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupClient() {
        name = Minecraft.func_71410_x().func_110432_I().func_111285_a().toLowerCase();
    }

    public static void init() {
        if (thread != null && thread.isAlive()) {
            return;
        }
        thread = new ThreadContributorListLoader();
    }

    public static int getTier(EntityPlayer player) {
        if (PatronRewardHandler.getTier(player.func_70005_c_()) == 99) {
            return 4;
        }
        return PatronRewardHandler.getTier(player.func_70005_c_());
    }

    public static int getTier(String name) {
        return tiers.getOrDefault(name.toLowerCase(Locale.ROOT), 0);
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            PatronRewardHandler.init();
        }
    }

    private static void load(Properties props) {
        ArrayList allPatrons = new ArrayList(props.size());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            String value = (String)v;
            int tier = Integer.parseInt(value);
            if (tier < 10) {
                allPatrons.add(key);
            }
            tiers.put(key.toLowerCase(Locale.ROOT), tier);
            if (name != null && key.toLowerCase(Locale.ROOT).equals(name)) {
                localPatronTier = tier;
            }
        }));
    }

    static {
        tiers = new HashMap<String, Integer>();
        localPatronTier = 0;
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Elenai Dodge Patron Loading Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/ElenaiDev/Patrons/master/contributors.properties");
                Properties patreonTiers = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                    patreonTiers.load(reader);
                    PatronRewardHandler.load(patreonTiers);
                }
            }
            catch (IOException e) {
                ElenaiDodge.LOG.error("Failed to load patreon information", (Throwable)e);
            }
        }
    }
}

