/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.capability.weight.IWeight;
import com.elenai.elenaidodge.capability.weight.WeightProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SWeightMessage
implements IMessage {
    private boolean messageValid;
    private double weight;

    public SWeightMessage() {
        this.messageValid = false;
    }

    public SWeightMessage(double weight) {
        this.weight = weight;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.weight = buf.readDouble();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeDouble(this.weight);
    }

    public static class Handler
    implements IMessageHandler<SWeightMessage, IMessage> {
        public IMessage onMessage(SWeightMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(SWeightMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            IWeight w = (IWeight)player.getCapability(WeightProvider.WEIGHT_CAP, null);
            w.set(message.weight);
        }
    }
}

