/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.api.thirst.ThirstHelper;

@ParametersAreNonnullByDefault
public final class TANHelper {
    private static final String _TAN = "toughasnails";
    private static final String _TAN_TEMPMODIFIER_SPI = "toughasnails.api.temperature.ITemperatureModifier";
    private static final int _MAX_TEMP_SHIFT = 9;
    public static ItemStack ICE_CUBE = null;
    static boolean INITED = false;
    static boolean INITED_FOODMGMT = false;
    static boolean INITED_LINING = false;
    static boolean INITED_PORTPAKS = false;
    static boolean ENABLED = false;
    static Potion FOOD_WARMING = Potions.NO_POTION;
    static Potion FOOD_COOLING = Potions.NO_POTION;

    public static final boolean isEnabled() {
        return ENABLED;
    }

    public static final void initFinal() {
        if (INITED) {
            return;
        }
        INITED = true;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            ICE_CUBE = ModIntegration.TOUGH_AS_NAILS.itemstack("ice_cube");
            ENABLED = !ICE_CUBE.func_190926_b();
        }
    }

    public static final void initFoodManagement(@Nonnull Potion warming, @Nonnull Potion cooling) {
        TANHelper.initFinal();
        if (INITED_FOODMGMT) {
            return;
        }
        INITED_FOODMGMT = true;
        Validate.isTrue((!Potions.isEmpty(warming) ? 1 : 0) != 0, (String)"Food warming indicator potion is required", (Object[])new Object[0]);
        Validate.isTrue((!Potions.isEmpty(cooling) ? 1 : 0) != 0, (String)"Food cooling indicator potion is required", (Object[])new Object[0]);
        Validate.isTrue((warming != cooling ? 1 : 0) != 0, (String)"Temperature indicator potions MUST be different from each other", (Object[])new Object[0]);
        if (ENABLED) {
            FOOD_WARMING = warming;
            FOOD_COOLING = cooling;
            TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new WarmingFoodModifier());
            TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new CoolingFoodModifier());
        }
    }

    public static final void initArmorLining() {
        TANHelper.initFinal();
        if (INITED_LINING) {
            return;
        }
        INITED_LINING = true;
        if (ENABLED) {
            TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new LinedArmorModifier());
            TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new AutoRegulatingArmorModifier());
        }
    }

    public static final void initPortablePaks() {
        TANHelper.initFinal();
        if (INITED_PORTPAKS) {
            return;
        }
        INITED_PORTPAKS = true;
        if (ENABLED) {
            TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new PortablePaksModifier());
        }
    }

    @Optional.Method(modid="toughasnails")
    public static final boolean manageTemperature() {
        return ENABLED && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_TEMPERATURE);
    }

    @Optional.Method(modid="toughasnails")
    public static final boolean manageThirst() {
        return ENABLED && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST);
    }

    @Optional.Method(modid="toughasnails")
    private static final boolean isThirsty(IThirst cap) {
        return cap != null && cap.getThirst() < 20;
    }

    public static final boolean isThirsty(@Nullable World world, EntityPlayer player) {
        boolean is = false;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst()) {
            IThirst cap = ThirstHelper.getThirstData((EntityPlayer)player);
            is = TANHelper.isThirsty(cap);
        }
        return is;
    }

    public static final boolean quenchThirst(EntityPlayer player, int thirstAmount, float hydration, float impurityChance) {
        boolean quenched = false;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst()) {
            IThirst cap = ThirstHelper.getThirstData((EntityPlayer)player);
            quenched = TANHelper.isThirsty(cap);
            cap.setExhaustion(0.0f);
            cap.addStats(thirstAmount, hydration);
            if (impurityChance > 0.0f && TANPotions.thirst != null && player.func_70681_au().nextFloat() < impurityChance) {
                Potions.addPotionEffect((EntityLivingBase)player, TANPotions.thirst, 30, 0);
            }
        }
        return quenched;
    }

    public static final void hydrateFor(int thirstAmount, EntityPlayer player) {
        IThirst cap;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst() && (cap = ThirstHelper.getThirstData((EntityPlayer)player)) != null && TANPotions.hydration != null) {
            player.func_70690_d(Potions.newStubbornPotionEffect(TANPotions.hydration, 1 + thirstAmount, 0, false, false));
        }
    }

    public static final boolean isPlayerAtExtremeTemperature(EntityPlayer player, boolean hot) {
        ITemperature temp;
        boolean is = false;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null) {
            is = TemperatureScale.isScalePosInRange((int)temp.getTemperature().getRawValue(), (TemperatureScale.TemperatureRange)(hot ? TemperatureScale.TemperatureRange.HOT : TemperatureScale.TemperatureRange.ICY));
        }
        return is;
    }

    public static final boolean coolIfHot(EntityPlayer player, int instantCooldown, int ongoingTimesecs, int fortifyTimesecs) {
        int scaleValue;
        ITemperature temp;
        boolean cooled = false;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null && TemperatureScale.isScalePosInRange((int)(scaleValue = temp.getTemperature().getRawValue()), (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.WARM, (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.HOT)) {
            boolean bl = cooled = instantCooldown > 0;
            if (cooled) {
                temp.setTemperature(new Temperature(scaleValue - instantCooldown));
                if (instantCooldown > 1) {
                    player.func_184589_d(TANPotions.hyperthermia);
                }
                if (ongoingTimesecs > 0) {
                    Potions.addPotionEffect((EntityLivingBase)player, FOOD_COOLING, ongoingTimesecs, instantCooldown - 1);
                }
            }
            if (fortifyTimesecs > 0 && TANPotions.heat_resistance != null) {
                Potions.addPotionEffect((EntityLivingBase)player, TANPotions.heat_resistance, fortifyTimesecs, 0, false, false);
            }
        }
        return cooled;
    }

    public static final boolean coolIfHot(EntityPlayer player, int instantCooldown, int ongoingTimesecs) {
        return TANHelper.coolIfHot(player, instantCooldown, ongoingTimesecs, -1);
    }

    public static final boolean warmIfCold(EntityPlayer player, int instantWarmup, int ongoingTimesecs, int fortifyTimesecs) {
        int scaleValue;
        ITemperature temp;
        boolean warmed = false;
        if (ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null && TemperatureScale.isScalePosInRange((int)(scaleValue = temp.getTemperature().getRawValue()), (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.ICY, (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.COOL)) {
            boolean bl = warmed = instantWarmup > 0;
            if (warmed) {
                temp.setTemperature(new Temperature(scaleValue + instantWarmup));
                if (instantWarmup > 1) {
                    player.func_184589_d(TANPotions.hypothermia);
                }
                if (ongoingTimesecs > 0) {
                    Potions.addPotionEffect((EntityLivingBase)player, FOOD_WARMING, ongoingTimesecs, instantWarmup - 1);
                }
            }
            if (fortifyTimesecs > 0 && TANPotions.cold_resistance != null) {
                Potions.addPotionEffect((EntityLivingBase)player, TANPotions.cold_resistance, fortifyTimesecs, 0, false, false);
            }
        }
        return warmed;
    }

    public static final boolean warmIfCold(EntityPlayer player, int instantWarmup, int ongoingTimesecs) {
        return TANHelper.warmIfCold(player, instantWarmup, ongoingTimesecs, -1);
    }

    private TANHelper() {
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class PortablePaksModifier
    extends PlayerModifierImpl {
        PortablePaksModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "carrots:portable_temp_pak";
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            List<ItemStack> sources;
            Temperature outT = iniT;
            if (TANHelper.manageTemperature() && !(sources = SharedGlue.getAffectingEntity(IsPortableTemperatureModifier.INSTANCE, (EntityLivingBase)player, false, true)).isEmpty()) {
                int modifier = 0;
                for (ItemStack pak : sources) {
                    ITemperatureChangeable t_cap = (ITemperatureChangeable)pak.func_77973_b();
                    int delta = t_cap.getTemperatureModifier(pak);
                    if (t_cap.isCooled(pak)) {
                        delta *= -1;
                    }
                    if (Math.abs(modifier += delta) < 9) continue;
                    break;
                }
                if (modifier != 0) {
                    int newT = iniT.getRawValue() + modifier;
                    m.addEntry(new IModifierMonitor.Context(this.getId(), Strings.translate("carrots.tooltip.tan.temppak.name"), iniT, new Temperature(newT)));
                    outT = new Temperature(newT);
                }
            }
            return outT;
        }

        static final class IsPortableTemperatureModifier
        implements Predicate<ItemStack> {
            static final IsPortableTemperatureModifier INSTANCE = new IsPortableTemperatureModifier();

            private IsPortableTemperatureModifier() {
            }

            public boolean apply(ItemStack check) {
                if (ItemStacks.isEmpty(check)) {
                    return false;
                }
                Item item = check.func_77973_b();
                if (!(item instanceof ITemperatureChangeable)) {
                    return false;
                }
                ITemperatureChangeable t_cap = (ITemperatureChangeable)item;
                return t_cap.getTemperatureDelivery() == ITemperatureChangeable.Category.CARRIED && t_cap.hasBonusTemperature(check);
            }
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class AutoRegulatingArmorModifier
    extends PlayerModifierImpl {
        AutoRegulatingArmorModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "carrots:regulating_armor";
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            TemperatureScale.TemperatureRange _HAPPY_PLACE = TemperatureScale.TemperatureRange.MILD;
            Temperature outT = iniT;
            if (TANHelper.manageTemperature()) {
                TemperatureScale.TemperatureRange adjust = null;
                int found_antifreeze = 0;
                boolean have_large_piece = false;
                for (ItemStack armor : player.func_184193_aE()) {
                    Armory.XLining.Def liningd = Armory.getXLining(armor);
                    if (adjust == null && liningd.name == Armory.XLining.TEMPERATURE_REGULATOR) {
                        int i = liningd.value;
                        TemperatureScale.TemperatureRange temperatureRange = i == 0 ? _HAPPY_PLACE : (adjust = i < 0 ? TemperatureScale.TemperatureRange.COOL : TemperatureScale.TemperatureRange.WARM);
                    }
                    if (liningd.name != Armory.XLining.ANTIFREEZE_SHIELD) continue;
                    ++found_antifreeze;
                    if (armor != player.func_184582_a(EntityEquipmentSlot.CHEST) && armor != player.func_184582_a(EntityEquipmentSlot.LEGS)) continue;
                    have_large_piece = true;
                }
                if (found_antifreeze > 0) {
                    if (have_large_piece) {
                        TemperatureScale.TemperatureRange temperatureRange = adjust == _HAPPY_PLACE ? TemperatureScale.TemperatureRange.COOL : (adjust = adjust == null ? _HAPPY_PLACE : adjust);
                    }
                    if (found_antifreeze > 3 && SharedGlue.isaServerWorld((IBlockAccess)player.func_130014_f_())) {
                        player.func_184589_d(TANPotions.cold_resistance);
                        Potions.addPotionEffect((EntityLivingBase)player, TANPotions.cold_resistance, 20, 0, true, false);
                    }
                }
                if (adjust != null) {
                    int haveT = iniT.getRawValue();
                    int wantT = TemperatureScale.getRangeStart((TemperatureScale.TemperatureRange)_HAPPY_PLACE) + _HAPPY_PLACE.getRangeSize() / 2;
                    int shift = wantT - haveT;
                    int max_shift = this.getMaxShift(adjust, iniT);
                    if ((shift = MathHelper.func_76125_a((int)shift, (int)(-max_shift), (int)max_shift)) != 0) {
                        int newT = iniT.getRawValue() + shift;
                        m.addEntry(new IModifierMonitor.Context(this.getId(), Strings.translate("carrots.tooltip.tan.xlining.auto.name"), iniT, new Temperature(newT)));
                        outT = new Temperature(newT);
                    }
                }
            }
            return outT;
        }

        @Optional.Method(modid="toughasnails")
        private int getMidpoint(TemperatureScale.TemperatureRange range) {
            return TemperatureScale.getRangeStart((TemperatureScale.TemperatureRange)range) + range.getRangeSize() / 2;
        }

        @Optional.Method(modid="toughasnails")
        private boolean isExtreme(Temperature iniT) {
            int at = iniT.getRawValue();
            return at >= this.getMidpoint(TemperatureScale.TemperatureRange.HOT) || at <= this.getMidpoint(TemperatureScale.TemperatureRange.ICY);
        }

        @Optional.Method(modid="toughasnails")
        private int getMaxShift(TemperatureScale.TemperatureRange adjust, Temperature iniT) {
            int max_shift = 6;
            if (this.isExtreme(iniT)) {
                max_shift = 9;
            }
            if (adjust == TemperatureScale.TemperatureRange.WARM) {
                max_shift += TemperatureScale.TemperatureRange.ICY.getRangeSize();
            } else if (adjust == TemperatureScale.TemperatureRange.COOL) {
                max_shift += TemperatureScale.TemperatureRange.HOT.getRangeSize();
            }
            return max_shift;
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class LinedArmorModifier
    extends PlayerModifierImpl {
        LinedArmorModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "carrots:lined_armor";
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            Temperature outT = iniT;
            if (TANHelper.manageTemperature()) {
                int modifier = 0;
                for (ItemStack armor : player.func_184193_aE()) {
                    modifier += Armory.getTLining(armor).getModifier();
                }
                if (modifier != 0) {
                    int newT = iniT.getRawValue() + modifier;
                    m.addEntry(new IModifierMonitor.Context(this.getId(), Strings.translate("carrots.tooltip.tan.xlining.temp.name"), iniT, new Temperature(newT)));
                    outT = new Temperature(newT);
                }
            }
            return outT;
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class CoolingFoodModifier
    extends PlayerModifierImpl {
        CoolingFoodModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "carrots:coldfood";
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            Temperature outT = iniT;
            Potion p = FOOD_COOLING;
            if (TANHelper.manageTemperature() && player.func_70644_a(p)) {
                int newT = iniT.getRawValue();
                m.addEntry(new IModifierMonitor.Context(this.getId(), Strings.translate("carrots.tooltip.tan.colddrink.name"), iniT, new Temperature(newT -= MathHelper.func_76125_a((int)(1 + player.func_70660_b(p).func_76458_c()), (int)1, (int)4))));
                outT = new Temperature(newT);
            }
            return outT;
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class WarmingFoodModifier
    extends PlayerModifierImpl {
        WarmingFoodModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "carrots:warmfood";
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            Temperature outT = iniT;
            Potion p = FOOD_WARMING;
            if (TANHelper.manageTemperature() && player.func_70644_a(p)) {
                int newT = iniT.getRawValue();
                m.addEntry(new IModifierMonitor.Context(this.getId(), Strings.translate("carrots.tooltip.tan.warmfood.name"), iniT, new Temperature(newT += MathHelper.func_76125_a((int)(1 + player.func_70660_b(p).func_76458_c()), (int)1, (int)4))));
                outT = new Temperature(newT);
            }
            return outT;
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static abstract class PlayerModifierImpl
    implements ITemperatureModifier {
        PlayerModifierImpl() {
        }

        @Optional.Method(modid="toughasnails")
        public final boolean isPlayerSpecific() {
            return true;
        }

        @Optional.Method(modid="toughasnails")
        public final Temperature applyEnvironmentModifiers(World w, BlockPos pos, Temperature iniT, IModifierMonitor m) {
            return iniT;
        }
    }
}

