/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.MagnifyingPotionEffect;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;
import org.jwaresoftware.mcmods.lib.api.ICurative;

public final class Potions {
    public static final PotionEffect[] EMPTY_EFFECTS = new PotionEffect[0];
    public static final int MAX_AMPLIFY_LEVEL = 4;
    public static final Potion NO_POTION = new Potion(false, 0){

        public String func_76393_a() {
            return "nopotion";
        }

        public boolean func_76397_a(int d, int a) {
            return false;
        }

        public void func_76394_a(EntityLivingBase le, int amplifier) {
        }

        public void func_180793_a(@Nullable Entity e, @Nullable Entity es, EntityLivingBase le, int a, double h) {
        }
    };
    private static final int _FOREVER_THRESHOLD_DURATION = 32000;
    static final String _CUSTOM_ELIXIR_EFFECTS_TAGNAME = "ElixirEffects";

    public static final void registerSharedDictIds(@Nonnull String dictKey) {
        OreDictionary.registerOre((String)dictKey, (Item)Items.field_151068_bn);
        OreDictionary.registerOre((String)dictKey, (Item)Items.field_185155_bH);
        OreDictionary.registerOre((String)dictKey, (Item)Items.field_185156_bI);
    }

    public static final void registerSharedDictIds() {
        Potions.registerSharedDictIds("itemPotionBottle");
    }

    public static final boolean isEmpty(@Nullable Potion p) {
        return p == null || p == NO_POTION;
    }

    public static final boolean isLikelyForever(PotionEffect e) {
        return e != null && e.func_76459_b() > 32000;
    }

    public static final ItemStack newPotionHeldItem(PotionType potion) {
        ItemStack potionitem = new ItemStack((Item)Items.field_151068_bn);
        potionitem = !PotionType.field_185176_a.func_148741_d((Object)potion.getRegistryName()) ? PotionUtils.func_185184_a((ItemStack)potionitem, (Collection)potion.func_185170_a()) : PotionUtils.func_185188_a((ItemStack)potionitem, (PotionType)potion);
        return potionitem;
    }

    public static final PotionEffect newPotionEffect(Potion potion, int duration, int amplifier, boolean ambient, boolean particles) {
        return new PotionEffect(potion, duration, amplifier, ambient, particles);
    }

    public static final PotionEffect newPotionEffect(Potion potion, int duration, int amplifier) {
        return new PotionEffect(potion, duration, amplifier);
    }

    public static final PotionEffect newPotionTypeEffect(Potion potion, int duration_secs, int amplifier) {
        return new PotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, false, true);
    }

    public static final PotionEffect newHiddenPotionTypeEffect(Potion potion, int duration_secs, int amplifier) {
        return new PotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, false, false);
    }

    public static final PotionEffect newStubbornPotionEffect(Potion potion, int duration, int amplifier, boolean ambient, boolean particles) {
        return new StubbornPotionEffect(potion, duration, amplifier, ambient, particles);
    }

    public static final PotionEffect newForeverEffect(Potion potion, int amplifier) {
        return new PotionEffect(potion, Integer.MAX_VALUE, amplifier, false, false);
    }

    public static final PotionEffect copyPotionEffect(PotionEffect potioneffect) {
        if (potioneffect instanceof MagnifyingPotionEffect) {
            return new MagnifyingPotionEffect((MagnifyingPotionEffect)potioneffect);
        }
        if (potioneffect instanceof StubbornPotionEffect) {
            return new StubbornPotionEffect((StubbornPotionEffect)potioneffect);
        }
        return new PotionEffect(potioneffect);
    }

    public static final boolean removePotionEffect(@Nonnull EntityLivingBase entity, @Nonnull Potion potion) {
        boolean tried = entity.func_70644_a(potion);
        entity.func_184589_d(potion);
        return tried;
    }

    public static final void removePotionEffect(@Nonnull EntityLivingBase entity, @Nonnull PotionType potion) {
        for (PotionEffect e : potion.func_185170_a()) {
            entity.func_184589_d(e.func_188419_a());
        }
    }

    public static final void curePotionEffects(EntityLivingBase player, ItemStack with) {
        player.curePotionEffects(with);
    }

    public static final void addPotionEffect(EntityLivingBase entity, Potion potion, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_70690_d(Potions.newPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, ambient, particles));
    }

    public static final void addPotionEffect(EntityLivingBase entity, Potion potion, int duration_secs, int amplifier) {
        entity.func_70690_d(Potions.newPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier));
    }

    public static final void addSecondaryPotionEffect(EntityLivingBase entity, Potion newpotion, Potion oldpotion, int amplifier) {
        PotionEffect current = entity.func_70660_b(oldpotion);
        if (current != null) {
            if (amplifier < 0) {
                amplifier = current.func_76458_c();
            }
            entity.func_70690_d(Potions.newPotionEffect(newpotion, current.func_76459_b(), amplifier, false, false));
        }
    }

    public static final void addPotionEffect(ItemFood food, Potion potion, int duration_secs, int amplifier, float chance) {
        food.func_185070_a(Potions.newPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier), chance);
    }

    public static final void applyPotionEffect(EntityLivingBase victim, Potion potion, int duration_secs, int amplifier) {
        if (potion.func_76403_b() && duration_secs <= 0) {
            potion.func_180793_a(null, null, victim, amplifier, 1.0);
        } else {
            Potions.addPotionEffect(victim, potion, duration_secs, amplifier);
        }
    }

    public static final void applyEffect(@Nonnull PotionEffect effect, @Nonnull EntityLivingBase victim) {
        if (effect.func_188419_a().func_76403_b() && effect.func_188419_a() != SharedGlue.Potion_saturation) {
            effect.func_188419_a().func_180793_a(null, null, victim, effect.func_76458_c(), 1.0);
        } else {
            victim.func_70690_d(Potions.copyPotionEffect(effect));
        }
    }

    public static final void addPotionEffects(@Nonnull EntityLivingBase victim, @Nonnull PotionType potion) {
        for (PotionEffect e : potion.func_185170_a()) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffects(@Nonnull EntityLivingBase victim, @Nonnull ItemStack potion_source) {
        List<PotionEffect> effects = Potions.getEffects(potion_source, false);
        for (PotionEffect e : effects) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffect(EntityLivingBase victim, Potion potion, int duration_secs, int amplifier, Object ... cures) {
        PotionEffect potioneffect = Potions.newPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier);
        if (cures != null) {
            for (Object cure : cures) {
                potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : new ItemStack((Item)cure));
            }
        }
        victim.func_70690_d(potioneffect);
    }

    public static final void addStubbornPotionEffect(EntityLivingBase entity, Potion potion, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_70690_d(Potions.newStubbornPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, ambient, particles));
    }

    public static final void addStubbornPotionEffect(EntityLivingBase entity, Potion potion, int duration_secs, int amplifier, Object ... cures) {
        PotionEffect potioneffect = Potions.newStubbornPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, false, false);
        if (cures != null) {
            for (Object cure : cures) {
                potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : new ItemStack((Item)cure));
            }
        }
        entity.func_70690_d(potioneffect);
    }

    public static final void addMagniferPotionEffect(EntityLivingBase entity, Potion potion, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        MagnifyingPotionEffect e = new MagnifyingPotionEffect(potion, duration_secs * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER(), amplifier, ambient, particles);
        entity.func_70690_d((PotionEffect)e);
    }

    public static final boolean isMilk(ItemStack stack, boolean modded) {
        Item item;
        Item item2 = item = !ItemStacks.isEmpty(stack) ? stack.func_77973_b() : null;
        if (item != null) {
            EnumAction useaction;
            if (item == Items.field_151117_aB) {
                return true;
            }
            FluidStack fluidstack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidstack != null) {
                String fluidName = fluidstack.getFluid().getName();
                if (Fluids.isMilk(fluidName)) {
                    if (ModIntegration.isUniversalBucket(stack)) {
                        return true;
                    }
                    EnumAction useaction2 = stack.func_77975_n();
                    if (useaction2 == EnumAction.DRINK || useaction2 == EnumAction.EAT) {
                        return true;
                    }
                } else if (modded && (fluidName.startsWith("milk_") || fluidName.endsWith("_milk"))) {
                    return true;
                }
            } else if (modded && ((useaction = stack.func_77975_n()) == EnumAction.DRINK || useaction == EnumAction.EAT)) {
                return ModIntegration.isCustomMilkBottle(stack);
            }
        }
        return false;
    }

    public static final boolean isCurative(@Nonnull EntityPlayer player, ItemStack item) {
        return Potions.isCurative(player, item, false);
    }

    public static final boolean isCurative(@Nonnull EntityPlayer player, ItemStack item, boolean general) {
        if (!ItemStacks.isEmpty(item)) {
            if (general && item.func_77973_b() instanceof ICurative) {
                return true;
            }
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                if (!potioneffect.isCurativeItem(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static final void addMilkBasedRegenEffect(ItemFood food, int duration, int amplifier) {
        Potions.addPotionEffect(food, SharedGlue.Potion_regeneration, duration, amplifier, 1.0f);
    }

    public static final void addMilkBasedRegenEffect(ItemFood food) {
        Potions.addMilkBasedRegenEffect(food, 15, 2);
    }

    public static final void removeAllEffects(@Nullable EntityLivingBase entity) {
        if (entity != null && entity.func_70089_S()) {
            ArrayList all = new ArrayList(entity.func_70651_bq());
            for (PotionEffect goodOrBad : all) {
                entity.func_184589_d(goodOrBad.func_188419_a());
            }
        }
    }

    public static final boolean isEffectivelyBad(PotionEffect effect) {
        Potion potion = effect.func_188419_a();
        boolean is = potion.func_76398_f();
        if (!is) {
            boolean inversed;
            boolean bl = inversed = effect.func_76458_c() < 0;
            if (inversed && (potion == SharedGlue.Potion_healthBoost || potion == SharedGlue.Potion_moveSpeed || potion == SharedGlue.Potion_resistance || potion == SharedGlue.Potion_jump || potion == SharedGlue.Potion_digSpeed)) {
                is = true;
            }
        }
        return is;
    }

    public static final boolean hasAtLeastOneNegativeEffect(@Nullable EntityPlayer player) {
        if (player != null) {
            Collection effects = player.func_70651_bq();
            for (PotionEffect effect : effects) {
                if (!Potions.isEffectivelyBad(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean cureAllBadEffects(@Nullable EntityLivingBase entity) {
        int affected = 0;
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Potion> remove = null;
            for (PotionEffect effect : effects) {
                if (!Potions.isEffectivelyBad(effect)) continue;
                if (remove == null) {
                    remove = new ArrayList<Potion>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Potion badpotion : remove) {
                    entity.func_184589_d(badpotion);
                    ++affected;
                }
            }
        }
        return affected > 0;
    }

    public static final void removeAllHelpfulEffects(@Nullable EntityLivingBase entity) {
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Potion> remove = null;
            for (PotionEffect effect : effects) {
                if (Potions.isEffectivelyBad(effect)) continue;
                if (remove == null) {
                    remove = new ArrayList<Potion>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Potion goodpotion : remove) {
                    entity.func_184589_d(goodpotion);
                }
            }
        }
    }

    public static final boolean cureJumpFailImplEffect(@Nonnull EntityPlayer player) {
        boolean done = false;
        PotionEffect e = player.func_70660_b(SharedGlue.Potion_jump);
        if (e != null && e.func_76458_c() < 0) {
            player.func_184589_d(SharedGlue.Potion_jump);
            done = true;
        }
        return done;
    }

    public static final void cureBadPotionEffectsWithMilk(@Nullable EntityPlayer player, boolean combatant, boolean muscle_boosted) {
        if (player != null) {
            player.func_184589_d(SharedGlue.Potion_harm);
            player.func_184589_d(SharedGlue.Potion_blindness);
            player.func_184589_d(SharedGlue.Potion_nausea);
            player.func_184589_d(SharedGlue.Potion_poison);
            player.func_184589_d(SharedGlue.Potion_hunger);
            Potions.cureJumpFailImplEffect(player);
            if (combatant) {
                player.func_184589_d(SharedGlue.Potion_wither);
                PotionEffect e = player.func_70660_b(SharedGlue.Potion_resistance);
                if (e != null && e.func_76458_c() < 0) {
                    player.func_184589_d(SharedGlue.Potion_resistance);
                }
            }
            if (muscle_boosted) {
                Potions.cureBadPotionEffectsWithMuscleBoost(player);
            }
        }
    }

    public static final void cureBadPotionEffectsWithMilkBucket(@Nullable EntityPlayer player) {
        if (player != null) {
            Potions.cureAllBadEffects((EntityLivingBase)player);
            Potions.addPotionEffect((EntityLivingBase)player, SharedGlue.Potion_regeneration, 10, 2, false, false);
        }
    }

    public static final void cureBadPotionEffectsWithMuscleBoost(EntityPlayer player) {
        if (player != null) {
            player.func_184589_d(SharedGlue.Potion_weakness);
            player.func_184589_d(SharedGlue.Potion_moveSlowdown);
            player.func_184589_d(SharedGlue.Potion_digSlowdown);
            Potions.cureJumpFailImplEffect(player);
        }
    }

    public static final void addMuscleBoostPotionEffect(EntityPlayer player, int duration_mins) {
        if (player != null) {
            if (duration_mins <= 0) {
                duration_mins = 2;
            }
            int duration = 60 * duration_mins;
            Potions.addPotionEffect((EntityLivingBase)player, SharedGlue.Potion_healthBoost, duration, 1, false, false);
            Potions.addPotionEffect((EntityLivingBase)player, SharedGlue.Potion_strength, duration, 1, false, false);
            Potions.addPotionEffect((EntityLivingBase)player, SharedGlue.Potion_resistance, duration, 1, false, false);
        }
    }

    public static final void onMuscleFoodEaten(EntityPlayer player, int duration_mins) {
        Potions.cureBadPotionEffectsWithMuscleBoost(player);
        Potions.addMuscleBoostPotionEffect(player, duration_mins);
    }

    public static final void cureBadPotionEffectsWithSmellingSalts(@Nullable EntityPlayer player) {
        if (SharedGlue.hasPotionsInEffect((EntityLivingBase)player)) {
            player.func_184589_d(SharedGlue.Potion_blindness);
            player.func_184589_d(SharedGlue.Potion_nausea);
            player.func_184589_d(SharedGlue.Potion_hunger);
            Potions.cureJumpFailImplEffect(player);
            Potions.cureBadPotionEffectsWithMuscleBoost(player);
        }
    }

    public static final ItemStack newTippedArrow(PotionType effect) {
        ItemStack arrow = new ItemStack(Items.field_185167_i);
        return PotionUtils.func_185188_a((ItemStack)arrow, (PotionType)effect);
    }

    public static final void cure(@Nonnull EntityPlayer player, @Nonnull ModIntegration mod, @Nonnull String potion_name) {
        Potion p = mod.potion(potion_name);
        if (p != null) {
            player.func_184596_c(p);
        }
    }

    public static final void cureChokingEffects(EntityPlayer player) {
        Potions.cure(player, ModIntegration.GRAVESTONE_EXT, "gs_choke_potion");
    }

    public static final void cureFireBurningEffects(@Nonnull EntityPlayer player, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect((EntityLivingBase)player)) {
            if (ModIntegration.POTION_CORE.isLoaded()) {
                Potions.cure(player, ModIntegration.POTION_CORE, "fire");
            }
            if (ModIntegration.GRAVESTONE_EXT.isLoaded()) {
                Potions.cure(player, ModIntegration.GRAVESTONE_EXT, "gs_burning_potion");
                Potions.cure(player, ModIntegration.GRAVESTONE_EXT, "gs_inferno_potion");
            }
            if (ModIntegration.EXTRA_ALCHEMY.isLoaded()) {
                Potions.cure(player, ModIntegration.EXTRA_ALCHEMY, "effect.combustion");
            }
            if (immediate && player.func_70027_ad()) {
                player.func_70066_B();
                Effects.playExtinguishedBurning(player.func_130014_f_(), player);
            }
        }
    }

    public static final void cureFreezingEffects(@Nonnull EntityPlayer player, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect((EntityLivingBase)player)) {
            if (ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
                Potions.cure(player, ModIntegration.TOUGH_AS_NAILS, "hypothermia");
            }
            if (ModIntegration.ELECTROBLOB_WIZARDRY.isLoaded()) {
                Potions.cure(player, ModIntegration.ELECTROBLOB_WIZARDRY, "frost");
            }
            if (ModIntegration.NETHER_EX.isLoaded()) {
                Potions.cure(player, ModIntegration.NETHER_EX, "freeze");
                Potions.cure(player, ModIntegration.NETHER_EX, "frostbite");
            }
            if (ModIntegration.SHOTGUNS_AND_GLITTER.isLoaded()) {
                Potions.cure(player, ModIntegration.SHOTGUNS_AND_GLITTER, "frost");
            }
            if (ModIntegration.EXTRA_ALCHEMY.isLoaded()) {
                Potions.cure(player, ModIntegration.EXTRA_ALCHEMY, "freezing");
            }
        }
    }

    public static final boolean hasCustomElixirEffects(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9);
    }

    static final List<PotionEffect> mergeCustomElixirEffects(@Nonnull NBTTagCompound from, @Nullable List<PotionEffect> effects) {
        if (effects == null) {
            effects = new ArrayList<PotionEffect>();
        }
        if (from.func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9)) {
            NBTTagList tagList = from.func_150295_c(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound effectData = tagList.func_150305_b(i);
                ResourceLocation effectName = new ResourceLocation(effectData.func_74779_i("Effect"));
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(effectName);
                if (potion == null) continue;
                int duration = effectData.func_74762_e("Duration");
                int amplifier = effectData.func_74762_e("Amplifier");
                if (duration <= 0 && (duration != 0 || !potion.func_76403_b())) continue;
                effects.add(new PotionEffect(potion, duration, amplifier));
            }
        }
        return effects;
    }

    public static final List<PotionEffect> getEffects(@Nonnull ItemStack stack, boolean any) {
        List effects = PotionUtils.func_185189_a((ItemStack)stack);
        if (any && Potions.hasCustomElixirEffects(stack)) {
            Potions.mergeCustomElixirEffects(stack.func_77978_p(), effects);
        }
        return effects;
    }

    public static final boolean matches(@Nonnull ItemStack stack, PotionType ingredient, boolean any) {
        if (Potions.isReal(ingredient)) {
            List<PotionEffect> have = Potions.getEffects(stack, any);
            List want = ingredient.func_185170_a();
            if (have.size() == want.size()) {
                if (want.size() == 1) {
                    return ((PotionEffect)want.get(0)).equals((Object)have.get(0));
                }
                for (PotionEffect e : want) {
                    if (have.contains(e)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static final void addCustomEffects(@Nonnull NBTTagCompound to, boolean replace, @Nullable Collection<PotionEffect> effects) {
        if (replace) {
            to.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
        }
        if (effects != null && !effects.isEmpty()) {
            NBTTagList eList = to.func_150295_c(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 10);
            for (PotionEffect effect : effects) {
                eList.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
            }
            to.func_74782_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), (NBTBase)eList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final void trackAttributeModifiers(PotionEffect effect, List<Tuple<String, AttributeModifier>> local_copies) {
        Potion potion = effect.func_188419_a();
        Map map = potion.func_111186_k();
        if (!map.isEmpty()) {
            for (Map.Entry iattrib : map.entrySet()) {
                AttributeModifier modifier = (AttributeModifier)iattrib.getValue();
                AttributeModifier local_copy = new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_111169_c());
                local_copies.add((Tuple<String, AttributeModifier>)new Tuple((Object)((IAttribute)iattrib.getKey()).func_111108_a(), (Object)local_copy));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final void addModifierInformation(List<Tuple<String, AttributeModifier>> attribs, List<String> tooltip) {
        tooltip.add("");
        tooltip.add(TextFormatting.DARK_PURPLE + Strings.translate("potion.whenDrank"));
        for (Tuple<String, AttributeModifier> tuple : attribs) {
            AttributeModifier modifier = (AttributeModifier)tuple.func_76340_b();
            double amount = modifier.func_111164_d();
            int op = modifier.func_111169_c();
            double value = op != 1 && op != 2 ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
            if (amount > 0.0) {
                tooltip.add(TextFormatting.BLUE + Strings.translateFormatted("attribute.modifier.plus." + op, ItemStack.field_111284_a.format(value), Strings.translate("attribute.name." + (String)tuple.func_76341_a())));
                continue;
            }
            if (!(amount < 0.0)) continue;
            tooltip.add(TextFormatting.RED + Strings.translateFormatted("attribute.modifier.take." + op, ItemStack.field_111284_a.format(value *= -1.0), Strings.translate("attribute.name." + (String)tuple.func_76341_a())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<PotionEffect> effects, @Nonnull List<String> tooltip, int durationOverride, boolean full, boolean indent) {
        String _PS;
        ArrayList<Tuple<String, AttributeModifier>> attribs = null;
        String string = _PS = indent ? " " : "";
        if (full) {
            if (effects.isEmpty()) {
                String displayString = Strings.translate("effect.none").trim();
                tooltip.add(_PS + TextFormatting.GRAY + displayString);
                return;
            }
            attribs = new ArrayList<Tuple<String, AttributeModifier>>();
        }
        for (PotionEffect effect : effects) {
            if (full) {
                Potions.trackAttributeModifiers(effect, attribs);
            }
            boolean bad = Potions.isEffectivelyBad(effect);
            String displayString = _PS + Strings.translate(effect.func_76453_d()).trim();
            if (effect.func_76458_c() != 0) {
                displayString = displayString + " " + Strings.translate("potion.potency." + Math.abs(effect.func_76458_c())).trim();
            }
            if (effect.func_76459_b() > SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER()) {
                if (durationOverride > 0) {
                    effect = new PotionEffect(effect.func_188419_a(), durationOverride);
                }
                displayString = displayString + " (" + Potion.func_188410_a((PotionEffect)effect, (float)1.0f) + ")";
            }
            tooltip.add((bad ? TextFormatting.RED : TextFormatting.BLUE) + displayString);
        }
        if (full && attribs != null && !attribs.isEmpty()) {
            Potions.addModifierInformation(attribs, tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<PotionEffect> effects, @Nonnull List<String> tooltip) {
        Potions.addPotionInformation(effects, tooltip, -1, false, false);
    }

    private static final boolean isdefined(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        PotionType type = PotionUtils.func_185187_c((NBTTagCompound)stack.func_77978_p());
        return type != null && type != PotionTypes.field_185229_a || stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 9) || Potions.hasCustomElixirEffects(stack);
    }

    public static final boolean isa(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item != Items.field_151068_bn && !any) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final boolean isap(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (!(item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI || any && RID.matches(stack, "itemPotionBottle"))) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final void eraseDefinition(ItemStack stack) {
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            NBTTagCompound current = stack.func_77978_p();
            current.func_82580_o("Potion");
            current.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
            current.func_82580_o(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
    }

    public static final boolean copyDefinition(ItemStack from, @Nonnull ItemStack to) {
        boolean copied = false;
        if (Potions.isa(from, true)) {
            int color;
            Potions.eraseDefinition(to);
            NBTTagCompound data = from.func_77978_p();
            boolean is_registered = data.func_74764_b("Potion");
            if (is_registered) {
                to.func_77983_a("Potion", data.func_74781_a("Potion").func_74737_b());
            }
            if (data.func_74764_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME())) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME()).func_74737_b());
            }
            if (data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME()).func_74737_b());
            } else if (!is_registered && to.func_77973_b() instanceof ItemTippedArrow && (color = PotionUtils.func_185181_a(Potions.getEffects(from, false))) != 3694022) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (NBTBase)new NBTTagInt(color));
            }
            copied = true;
        }
        return copied;
    }

    public static final void copyDefinition(@Nonnull ItemStack to, @Nonnull Collection<PotionEffect> effects, @Nullable Integer customColor) {
        Potions.eraseDefinition(to);
        Potions.addCustomEffects(ItemStacks.getTagCompoundNonNull(to), false, effects);
        if (customColor != null) {
            to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (NBTBase)new NBTTagInt(customColor.intValue()));
        }
    }

    public static final boolean isReal(@Nullable PotionType type) {
        return type == null ? false : type != PotionTypes.field_185229_a && type != PotionTypes.field_185230_b && type != PotionTypes.field_185231_c && !type.func_185170_a().isEmpty();
    }

    @Nullable
    private static final String getCustomUnlocalizedName(ItemStack stack) {
        String name = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME(), 8)) {
            name = stack.func_77978_p().func_74779_i(SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME());
        }
        return name;
    }

    @Nullable
    public static final String getTypeDisplayNameOrNull(@Nonnull ItemStack stack) {
        String name = Potions.getCustomUnlocalizedName(stack);
        if (name != null) {
            name = Strings.translate(name) + "*";
        } else {
            PotionType type = PotionUtils.func_185191_c((ItemStack)stack);
            if (Potions.isReal(type)) {
                name = Strings.translate(type.func_185174_b("potion.effect."));
            }
        }
        return name;
    }

    @Nullable
    public static final String getTypeTranslationKeyOrNull(@Nonnull ItemStack stack, String prefix) {
        String lookup = null;
        PotionType type = PotionUtils.func_185191_c((ItemStack)stack);
        if (type == PotionTypes.field_185229_a) {
            lookup = Potions.getCustomUnlocalizedName(stack);
        } else if (Potions.isReal(type)) {
            if (prefix == null) {
                prefix = "";
            }
            if (!Strings.hasTranslation(lookup = type.func_185174_b(prefix))) {
                lookup = null;
            }
        }
        return lookup;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack, @Nonnull Collection<PotionEffect> effects) {
        NBTTagCompound data;
        Integer color_num = null;
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o() && (data = stack.func_77978_p()).func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
            color_num = data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
        if (color_num == null && !effects.isEmpty()) {
            color_num = PotionUtils.func_185181_a(effects);
        }
        return color_num;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack) {
        Integer color_num = null;
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            NBTTagCompound data = stack.func_77978_p();
            color_num = data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99) ? Integer.valueOf(data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME())) : Integer.valueOf(PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack)));
        }
        return color_num;
    }

    protected Potions() {
    }

    public static final void init0() {
    }
}

