/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.utils;

import WayofTime.bloodmagic.BloodMagic;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import codersafterdark.compatskills.common.compats.reskillable.customcontent.CrTSkill;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.IChangeHandler;
import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import com.cout970.magneticraft.api.MagneticraftApi;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.research.ResearchCategories;

public class CheckMethods {
    public static boolean checkIItemstack(IItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            CraftTweakerAPI.logError((String)("Itemstack: " + stack + " was found to be either null or empty!"));
            return false;
        }
        return true;
    }

    public static boolean checkChangeHandler(IChangeHandler handler) {
        if (handler == null) {
            CraftTweakerAPI.logError((String)"IChangeHandler was found to be null!");
            return false;
        }
        return true;
    }

    public static boolean checkStringArray(String[] strings) {
        if (strings == null || strings.length == 0) {
            CraftTweakerAPI.logError((String)"String Array 'locked' was found to have no entries!");
            return false;
        }
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            CraftTweakerAPI.logError((String)"String was found to be either null or empty!");
            return false;
        }
        return true;
    }

    public static boolean checkOptionalRequirements(String[] strings) {
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (string != null && !string.isEmpty()) continue;
                CraftTweakerAPI.logError((String)"String was found to be either null or empty!");
                return false;
            }
        }
        return true;
    }

    public static boolean checkString(String message) {
        if (message == null || message.isEmpty()) {
            CraftTweakerAPI.logError((String)"'String' Param is either null or empty!");
            return false;
        }
        return true;
    }

    public static boolean checkInt(int i) {
        if (i < 0) {
            CraftTweakerAPI.logError((String)("Integer, " + i + ", was found to be lower than 0, this is not allowed!"));
            return false;
        }
        return true;
    }

    public static boolean checkLong(long i) {
        if (i < 0L) {
            CraftTweakerAPI.logError((String)("Long, " + i + ", was found to be lower than 0, this is not allowed!"));
            return false;
        }
        return true;
    }

    public static boolean checkDouble(double i) {
        if (i < 0.0) {
            CraftTweakerAPI.logError((String)("Double, " + i + ", was found to be lower than 0, this is not allowed!"));
            return false;
        }
        return true;
    }

    public static boolean checkFloat(float i) {
        if (i < 0.0f) {
            CraftTweakerAPI.logError((String)("Float, " + i + ", was found to be lower than 0, this is not allowed!"));
            return false;
        }
        return true;
    }

    public static boolean checkModLoaded(String modid) {
        if (modid == null || modid.isEmpty()) {
            CraftTweakerAPI.logError((String)"String Mod ID was Null or Empty!");
            return false;
        }
        if (!Loader.isModLoaded((String)modid)) {
            CraftTweakerAPI.logError((String)("Mod Id: " + modid + " Is not Loaded!"));
            return false;
        }
        return true;
    }

    public static boolean checkValidNBTTagCompound(IData tag) {
        if (tag == null) {
            CraftTweakerAPI.logError((String)"'IData' Param is null!");
            return false;
        }
        if (!(tag instanceof DataMap)) {
            CraftTweakerAPI.logError((String)("Invalid NBT Tag: " + tag.asString()));
            return false;
        }
        return true;
    }

    public static boolean checkValidDimension(int dimension) {
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            CraftTweakerAPI.logError((String)("Dimension: " + dimension + " was found to not be registered!"));
            return false;
        }
        return true;
    }

    public static boolean checkValidIEntityDefinition(IEntityDefinition entity) {
        if (entity == null) {
            CraftTweakerAPI.logError((String)"IEntityDefinition was found to be null");
            return false;
        }
        return true;
    }

    public static boolean checkValidTileEntityName(String tileName) {
        if (tileName == null || tileName.isEmpty()) {
            CraftTweakerAPI.logError((String)"String Tile Name Param is either null or empty!");
            return false;
        }
        if (!TileEntity.field_190562_f.func_148741_d((Object)new ResourceLocation(tileName))) {
            CraftTweakerAPI.logError((String)("Tile Entity " + tileName + " is not a valid Tile Entity Name"));
            return false;
        }
        return true;
    }

    public static boolean checkIOreDictEntry(IOreDictEntry entry) {
        if (entry == null || !OreDictionary.doesOreNameExist((String)entry.getName())) {
            CraftTweakerAPI.logError((String)("Ore Dictionary Entry: " + entry + " was found to be either null or does not exist!"));
            return false;
        }
        return true;
    }

    public static boolean checkResourceLocation(String message) {
        if (message == null || message.isEmpty()) {
            CraftTweakerAPI.logError((String)"'String' Param is either null or empty!");
            return false;
        }
        if (!message.contains(":")) {
            CraftTweakerAPI.logError((String)("'String' Param, " + message + ", is not a valid resource location!"));
            return false;
        }
        return true;
    }

    public static boolean checkRitual(String ritual) {
        if (ritual == null || ritual.isEmpty()) {
            CraftTweakerAPI.logError((String)"String Ritual was Null or Empty!");
            return false;
        }
        if (BloodMagic.RITUAL_MANAGER.getRitual(ritual) == null) {
            CraftTweakerAPI.logError((String)("Invalid Ritual: " + ritual));
            return false;
        }
        return true;
    }

    public static boolean checkCategory(String categoryName) {
        if (categoryName == null || categoryName.isEmpty()) {
            CraftTweakerAPI.logError((String)"String Category was Null or Empty!");
            return false;
        }
        if (ResearchCategories.getResearchCategory((String)categoryName) == null) {
            CraftTweakerAPI.logError((String)("Invalid category: " + categoryName));
            return false;
        }
        return true;
    }

    public static boolean checkKnowledgeType(String knowledgeType) {
        IPlayerKnowledge.EnumKnowledgeType[] knowledgeTypes;
        if (knowledgeType == null || knowledgeType.isEmpty()) {
            CraftTweakerAPI.logError((String)"String Knowledge Type was Null or Empty!");
            return false;
        }
        for (IPlayerKnowledge.EnumKnowledgeType type : knowledgeTypes = IPlayerKnowledge.EnumKnowledgeType.values()) {
            if (!knowledgeType.equals(type.getAbbreviation())) continue;
            return true;
        }
        CraftTweakerAPI.logError((String)("Invalid Knowledge Type: " + knowledgeType));
        return false;
    }

    public static boolean checkIntX(int x) {
        if (x < 0 || x > 4) {
            CraftTweakerAPI.logError((String)("X-Pos needs to be between 0 and 4, found: " + x));
            return false;
        }
        return true;
    }

    public static boolean checkIntY(int y) {
        if (y < 0 || y > 3) {
            CraftTweakerAPI.logError((String)("Y-Pos needs to be between 0 and 3, found: " + y));
            return false;
        }
        return true;
    }

    public static boolean checkParentSkillsString(String parent) {
        if (parent == null || parent.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Parent Skill was found to be null or empty!");
            return false;
        }
        if (!ReskillableRegistries.SKILLS.containsKey(new ResourceLocation(parent))) {
            CraftTweakerAPI.logError((String)("String Resource Location, " + parent + ", is not a Valid Skill!"));
            return false;
        }
        return true;
    }

    public static boolean checkParentUnlockablesString(String parent) {
        if (parent == null || parent.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Parent Unlockable was found to be null or empty!");
            return false;
        }
        if (!ReskillableRegistries.UNLOCKABLES.containsKey(new ResourceLocation(parent))) {
            CraftTweakerAPI.logError((String)("String Resource Location, " + parent + ", is not a Valid Unlockable!"));
            return false;
        }
        return true;
    }

    public static boolean checkCrTSkillParent(CrTSkill parent) {
        if (parent == null) {
            CraftTweakerAPI.logError((String)"CrTSkill Parent is found to be Null!");
            return false;
        }
        ResourceLocation registryName = parent.getRegistryName();
        if (registryName == null) {
            CraftTweakerAPI.logError((String)"CrTSkill Parent registry found to be Null!");
            return false;
        }
        return CheckMethods.checkParentSkillsString(registryName.toString());
    }

    public static boolean checkSkill(Skill skill) {
        if (skill == null) {
            CraftTweakerAPI.logError((String)"Skill is found to be Null!");
            return false;
        }
        ResourceLocation registryName = skill.getRegistryName();
        if (registryName == null) {
            CraftTweakerAPI.logError((String)"Skill registry found to be Null!");
            return false;
        }
        return CheckMethods.checkParentSkillsString(registryName.toString());
    }

    public static boolean checkUnlockable(Unlockable unlockable) {
        if (unlockable == null) {
            CraftTweakerAPI.logError((String)"Unlockable is found to be Null!");
            return false;
        }
        ResourceLocation registryName = unlockable.getRegistryName();
        if (registryName == null) {
            CraftTweakerAPI.logError((String)"Unlockable registry found to be Null!");
            return false;
        }
        return CheckMethods.checkParentUnlockablesString(registryName.toString());
    }

    public static boolean checkValidMultiblockNameIE(String multiBlock) {
        if (multiBlock == null || multiBlock.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Multiblock Name was found to be null or empty!");
            return false;
        }
        if (MultiblockHandler.getMultiblocks().parallelStream().map(MultiblockHandler.IMultiblock::getUniqueName).noneMatch(multiBlock::equals)) {
            CraftTweakerAPI.logError((String)("No valid IE multiblock match was found for the String: " + multiBlock));
            return false;
        }
        return true;
    }

    public static boolean checkValidMultiblockNameMag(String multiBlock) {
        if (multiBlock == null || multiBlock.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Multiblock Name was found to be null or empty!");
            return false;
        }
        if (!MagneticraftApi.getMultiblockManager().getRegisteredMultiblocks().containsKey(multiBlock)) {
            CraftTweakerAPI.logError((String)("No valid MagnetiCraft multiblock match was found for the String: " + multiBlock));
            return false;
        }
        return true;
    }

    public static boolean checkModifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Modifier Identifier was found to be null or empty!");
            return false;
        }
        if (TinkerRegistry.getAllModifiers().parallelStream().map(IToolMod::getIdentifier).noneMatch(identifier::equals)) {
            CraftTweakerAPI.logError((String)("No valid modifier match was found for the String: " + identifier));
            return false;
        }
        return true;
    }

    public static boolean checkMaterial(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            CraftTweakerAPI.logError((String)"String for Material Identifier was found to be null or empty!");
            return false;
        }
        if (TinkerRegistry.getAllMaterials().parallelStream().map(Material::getIdentifier).noneMatch(identifier::equals)) {
            CraftTweakerAPI.logError((String)("No valid material match was found for the String: " + identifier));
            return false;
        }
        return true;
    }

    public static IBlockState convertItemStackToIBlockState(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
        }
        CraftTweakerAPI.logError((String)("ItemStack: " + stack.func_82833_r() + " is not an instanceof ItemBlock!"));
        return null;
    }
}

