/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.loader;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.recipesystem.Recipe;
import com.teamacronymcoders.base.recipesystem.loader.JsonRecipeLoader;
import com.teamacronymcoders.base.recipesystem.source.IRecipeSource;
import com.teamacronymcoders.base.recipesystem.source.RecipeSource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.commons.io.FilenameUtils;

public class ServerConfigJsonRecipeLoader
extends JsonRecipeLoader {
    private static ServerConfigJsonRecipeLoader instance;
    private final IRecipeSource RECIPE_SOURCE = new RecipeSource("server", true);

    public static ServerConfigJsonRecipeLoader getInstance() {
        if (instance == null) {
            instance = new ServerConfigJsonRecipeLoader();
        }
        return instance;
    }

    @Override
    public IRecipeSource getRecipeSource() {
        return this.RECIPE_SOURCE;
    }

    @Override
    public List<Recipe> loadRecipes() {
        File[] modFolders;
        ArrayList recipes = Lists.newArrayList();
        Path resourcesPath = Paths.get(Base.instance.getMinecraftFolder().getPath(), "resources");
        File resourcesFolder = resourcesPath.toFile();
        if (resourcesFolder.exists() && (modFolders = resourcesFolder.listFiles(File::isDirectory)) != null) {
            for (File modFolder : modFolders) {
                File recipesFolder = new File(modFolder, "base/recipe_system");
                if (!recipesFolder.exists()) continue;
                JsonContext jsonContext = new JsonContext(modFolder.getName());
                Path root = Paths.get(recipesFolder.getPath(), new String[0]);
                File[] recipeJsons = recipesFolder.listFiles(file -> FilenameUtils.getExtension((String)file.getName()).equals("json"));
                if (recipeJsons == null) continue;
                for (File recipeJson : recipeJsons) {
                    Path file2 = Paths.get(recipeJson.getPath(), new String[0]);
                    Optional.ofNullable(this.loadRecipe(jsonContext, root, file2)).ifPresent(recipes::add);
                }
            }
        }
        return recipes;
    }
}

