/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.entities;

import com.teamacronymcoders.base.Base;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EntityMinecartBase
extends EntityMinecart {
    public EntityMinecartBase(World world) {
        super(world);
    }

    @Nonnull
    public abstract ItemMinecart getItem();

    @Nonnull
    public ItemStack getCartItem() {
        ItemStack cartItemStack = new ItemStack((Item)this.getItem(), 1, this.getMetadata());
        this.getCartItemNBT().ifPresent(arg_0 -> ((ItemStack)cartItemStack).func_77982_d(arg_0));
        if (!this.func_70005_c_().isEmpty()) {
            cartItemStack.func_151001_c(this.func_70005_c_());
        }
        return cartItemStack;
    }

    public Optional<NBTTagCompound> getCartItemNBT() {
        return Optional.empty();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, hand))) {
            if (this.canBeRidden()) {
                if (player.func_70093_af()) {
                    return false;
                }
                if (this.func_184207_aI()) {
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184220_m((Entity)this);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_94095_a(@Nonnull DamageSource damageSource) {
        this.func_70106_y();
    }

    @Nonnull
    public EntityMinecart.Type func_184264_v() {
        Base.instance.getLogger().fatal("Someone called EntityMinecart.getType(). This doesn't work for Modded Entities");
        return EntityMinecart.Type.TNT;
    }

    public boolean isPoweredCart() {
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
            this.dropCart();
        }
    }

    public boolean canBeRidden() {
        return false;
    }

    public void dropCart() {
        this.dropCartItemStack(this.getCartItem());
    }

    public void dropCartItemStack(ItemStack cartItem) {
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70099_a(cartItem, 0.1f);
        }
    }

    public int getMetadata() {
        return 0;
    }
}

