/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanhudbaubles.client.gui;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.oblivioussp.spartanhudbaubles.client.event.RenderBaubleOnHUDEvent;
import com.oblivioussp.spartanhudbaubles.client.gui.AlignmentHelper;
import com.oblivioussp.spartanhudbaubles.client.gui.GuiPreviewHUD;
import com.oblivioussp.spartanhudbaubles.client.gui.HudElement;
import com.oblivioussp.spartanhudbaubles.util.Config;
import com.oblivioussp.spartanhudbaubles.util.SkinType;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="spartanhudbaubles", value={Side.CLIENT})
public class HudElementBaubles
extends HudElement {
    private static HudElementBaubles ACTIVE = null;
    private static final ResourceLocation HUD = new ResourceLocation("spartanhudbaubles", "textures/gui/hud.png");
    private static final ResourceLocation BAUBLES_EXPANDED_INVENTORY = new ResourceLocation("baubles", "textures/gui/expanded_inventory.png");
    private static final int DEFAULT_WIDTH = 130;
    private static final int DEFAULT_HEIGHT = 22;
    private boolean isPreview = false;

    public HudElementBaubles() {
        super(130, 22);
    }

    public HudElementBaubles(boolean enablePreview) {
        this();
        this.isPreview = enablePreview;
    }

    @Override
    public void render() {
        ArrayList<ItemStack> stacksToRender = new ArrayList<ItemStack>();
        if (!this.isPreview) {
            IBaublesItemHandler baublesHandler = BaublesApi.getBaublesHandler((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            for (int i = 0; i < baublesHandler.getSlots(); ++i) {
                ItemStack checkStack = baublesHandler.getStackInSlot(i);
                if (checkStack.func_190926_b()) continue;
                stacksToRender.add(checkStack);
            }
        }
        int slotsToRender = this.isPreview ? 7 : stacksToRender.size();
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        if (!this.isPreview && (stacksToRender.isEmpty() || mc.field_71439_g.func_175149_v())) {
            return;
        }
        GlStateManager.func_179147_l();
        int x = this.getAlignedX(Config.hudAlignment, Config.hudOffsetX, res);
        int y = this.getAlignedY(Config.hudAlignment, Config.hudOffsetY, res);
        AlignmentHelper.HorizontalAlignment horizontal = Config.hudAlignment.getHorizontal();
        AlignmentHelper.VerticalAlignment vertical = Config.hudAlignment.getVertical();
        GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
        int startX = 3;
        int startY = 3;
        int spacing = 2;
        int length = (Config.hudRotateVertical ? startY : startX) * 2 + 16 * slotsToRender + spacing * (slotsToRender - 1);
        if (!Config.hudRotateVertical && length != this.width) {
            this.width = length;
            this.height = 22;
        }
        if (Config.hudRotateVertical && length != this.height) {
            this.height = length;
            this.width = 22;
        }
        if (Config.showBaublesIcon && Config.skinType != SkinType.NONE) {
            int iconX;
            mc.func_110434_K().func_110577_a(BAUBLES_EXPANDED_INVENTORY);
            int n = Config.hudRotateVertical ? x + 6 : (iconX = horizontal == AlignmentHelper.HorizontalAlignment.LEFT ? x + this.width + 1 : x - 11);
            int iconY = Config.hudRotateVertical ? (vertical == AlignmentHelper.VerticalAlignment.BOTTOM ? y - 11 : y + this.height + 1) : y + 6;
            gui.func_73729_b(iconX, iconY, 210, 48, 10, 10);
        }
        block0 : switch (Config.skinType) {
            case HOTBAR_STYLE: {
                mc.func_110434_K().func_110577_a(HUD);
                switch (slotsToRender) {
                    case 1: {
                        gui.func_73729_b(x, y, 0, 0, 22, 22);
                        break block0;
                    }
                    case 2: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 21, 22, Config.hudRotateVertical);
                        this.drawTextureRectFromRotation(x, y, 21, 135, 0, 19, 22, Config.hudRotateVertical);
                        break block0;
                    }
                    case 3: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 39, 22, Config.hudRotateVertical);
                        this.drawTextureRectFromRotation(x, y, 39, 135, 0, 19, 22, Config.hudRotateVertical);
                        break block0;
                    }
                    case 4: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 39, 22, Config.hudRotateVertical);
                        this.drawTextureRectFromRotation(x, y, 39, 117, 0, 37, 22, Config.hudRotateVertical);
                        break block0;
                    }
                    case 5: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 57, 22, Config.hudRotateVertical);
                        this.drawTextureRectFromRotation(x, y, 57, 117, 0, 37, 22, Config.hudRotateVertical);
                        break block0;
                    }
                    case 6: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 57, 22, Config.hudRotateVertical);
                        this.drawTextureRectFromRotation(x, y, 57, 99, 0, 55, 22, Config.hudRotateVertical);
                        break block0;
                    }
                    case 7: {
                        this.drawTextureRectFromRotation(x, y, 0, 24, 0, 130, 22, Config.hudRotateVertical);
                        break block0;
                    }
                }
                break;
            }
            case TOOLTIP_STYLE: {
                gui.func_73733_a(x + 1, y, x + this.width - 1, y + 1, Config.tooltipBackgroundColour, Config.tooltipBackgroundColour);
                gui.func_73733_a(x + 1, y + this.height - 1, x + this.width - 1, y + this.height, Config.tooltipBackgroundColour, Config.tooltipBackgroundColour);
                gui.func_73733_a(x, y + 1, x + 1, y + this.height - 1, Config.tooltipBackgroundColour, Config.tooltipBackgroundColour);
                gui.func_73733_a(x + this.width - 1, y + 1, x + this.width, y + this.height - 1, Config.tooltipBackgroundColour, Config.tooltipBackgroundColour);
                gui.func_73733_a(x + 1, y + 1, x + this.width - 1, y + this.height - 1, Config.tooltipBackgroundColour, Config.tooltipBackgroundColour);
                gui.func_73733_a(x + 1, y + 1, x + this.width - 1, y + 2, Config.tooltipFrameTopColour, Config.tooltipFrameTopColour);
                gui.func_73733_a(x + 1, y + this.height - 2, x + this.width - 1, y + this.height - 1, Config.tooltipFrameBottomColour, Config.tooltipFrameBottomColour);
                gui.func_73733_a(x + 1, y + 2, x + 2, y + this.height - 2, Config.tooltipFrameTopColour, Config.tooltipFrameBottomColour);
                gui.func_73733_a(x + this.width - 2, y + 2, x + this.width - 1, y + this.height - 2, Config.tooltipFrameTopColour, Config.tooltipFrameBottomColour);
                break;
            }
            case MINIMAL: {
                gui.func_73733_a(x, y, x + this.width, y + this.height, Config.minimalTopColour, Config.minimalBottomColour);
                break;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        if (!this.isPreview) {
            for (int i = 0; i < stacksToRender.size(); ++i) {
                ItemStack stack = (ItemStack)stacksToRender.get(i);
                int offsetX = Config.hudRotateVertical ? x + startX : x + startX + (16 + spacing) * i;
                int offsetY = Config.hudRotateVertical ? y + startY + (16 + spacing) * i : y + startY;
                MinecraftForge.EVENT_BUS.post((Event)new RenderBaubleOnHUDEvent.Pre(stack, offsetX, offsetY, Config.hudAlignment, Config.hudRotateVertical, res, gui, mc.field_71466_p));
                mc.func_175599_af().func_180450_b(stack, offsetX, offsetY);
                mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, offsetX, offsetY, null);
                MinecraftForge.EVENT_BUS.post((Event)new RenderBaubleOnHUDEvent.Post(stack, offsetX, offsetY, Config.hudAlignment, Config.hudRotateVertical, res, gui, mc.field_71466_p));
            }
        } else {
            mc.func_110434_K().func_110577_a(BAUBLES_EXPANDED_INVENTORY);
            ItemStack stack = new ItemStack(Blocks.field_180401_cv);
            for (int i = 0; i < slotsToRender; ++i) {
                int offsetX = Config.hudRotateVertical ? x + startX : x + startX + (16 + spacing) * i;
                int offsetY = Config.hudRotateVertical ? y + startY + (16 + spacing) * i : y + startY;
                gui.func_73729_b(offsetX + 3, offsetY + 3, 200, 48, 10, 10);
            }
        }
        RenderHelper.func_74518_a();
    }

    private void drawTextureRectFromRotation(int x, int y, int offset, int textureU, int textureV, int width, int height, boolean rotate) {
        int texX = rotate ? x : x + offset;
        int texY = rotate ? y + offset : y;
        int texU = rotate ? textureV : textureU;
        int texV = rotate ? textureU : textureV;
        int texWidth = rotate ? height : width;
        int texHeight = rotate ? width : height;
        Minecraft.func_71410_x().field_71456_v.func_73729_b(texX, texY, texU, texV, texWidth, texHeight);
    }

    @SubscribeEvent
    public static void onHUDOverlay(RenderGameOverlayEvent.Post ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Config.disableHUD && ev.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            if (mc == null || mc.field_71462_r != null && mc.field_71462_r.getClass() == GuiPreviewHUD.class) {
                return;
            }
            if (ACTIVE == null) {
                ACTIVE = new HudElementBaubles();
            }
            ACTIVE.render();
        }
    }
}

