/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.world.biome;

import java.util.Random;
import lykrast.defiledlands.common.entity.monster.EntityHost;
import lykrast.defiledlands.common.entity.monster.EntityScuttler;
import lykrast.defiledlands.common.entity.monster.EntityShambler;
import lykrast.defiledlands.common.entity.monster.EntityShamblerTwisted;
import lykrast.defiledlands.common.entity.passive.EntityBookWyrm;
import lykrast.defiledlands.common.init.ModBlocks;
import lykrast.defiledlands.common.util.Config;
import lykrast.defiledlands.common.world.feature.WorldGenBlastem;
import lykrast.defiledlands.common.world.feature.WorldGenConjuringAltar;
import lykrast.defiledlands.common.world.feature.WorldGenCorruptionPost;
import lykrast.defiledlands.common.world.feature.WorldGenDungeonsDefiled;
import lykrast.defiledlands.common.world.feature.WorldGenScuronotte;
import lykrast.defiledlands.common.world.feature.WorldGenTenebra;
import lykrast.defiledlands.common.world.feature.WorldGenVilespine;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiomeDefiled
extends Biome {
    public static WorldGenerator vilespineGen = new WorldGenVilespine();
    public static WorldGenerator blastemGen = new WorldGenBlastem();
    public static WorldGenerator tenebraGen = new WorldGenTenebra(false);
    public static WorldGenerator scuronotteGen = new WorldGenScuronotte();
    public static WorldGenerator corruptionPosGen = new WorldGenCorruptionPost();
    public static WorldGenerator dungeonsGen = new WorldGenDungeonsDefiled();
    public static WorldGenerator altarGen = new WorldGenConjuringAltar();
    protected int vilespinePerChunk;
    protected int scuronottePerChunk;

    public BiomeDefiled(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76752_A = ModBlocks.grassDefiled.func_176223_P();
        this.field_76753_B = ModBlocks.dirtDefiled.func_176223_P();
        this.vilespinePerChunk = 50;
        this.scuronottePerChunk = 2;
    }

    public void cleanSpawnLists() {
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        if (Config.bookWyrmSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityBookWyrm.class, 16, 2, 4));
        }
        if (Config.weightShambler > 0) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityShambler.class, Config.weightShambler, 1, 2));
        }
        if (Config.weightTwistedShambler > 0) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityShamblerTwisted.class, Config.weightTwistedShambler, 1, 2));
        }
        if (Config.weightScuttler > 0) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityScuttler.class, Config.weightScuttler, 1, 3));
        }
        if (Config.weightHost > 0) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityHost.class, Config.weightHost, 2, 3));
        }
    }

    public float func_76741_f() {
        return 0.13f;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return (WorldGenAbstractTree)(rand.nextInt(5) > 0 ? tenebraGen : field_76757_N);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int j;
        int i;
        for (i = 0; i < 80; ++i) {
            int x = rand.nextInt(16) + 8;
            int z = rand.nextInt(16) + 8;
            int y = rand.nextInt(256);
            dungeonsGen.func_180709_b(worldIn, rand, pos.func_177982_a(x, y, z));
        }
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DESERT_WELL) && worldIn.func_175726_f(pos).func_76617_a(119432789L).nextInt(50) == 0) {
            i = rand.nextInt(16) + 8;
            j = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(i, 0, j)).func_177984_a();
            altarGen.func_180709_b(worldIn, rand, blockpos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            for (int j5 = 0; j5 < this.vilespinePerChunk; ++j5) {
                int k13;
                int l9 = rand.nextInt(16) + 8;
                int l16 = worldIn.func_175645_m(pos.func_177982_a(l9, 0, k13 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (l16 <= 0) continue;
                int j19 = rand.nextInt(l16);
                vilespineGen.func_180709_b(worldIn, rand, pos.func_177982_a(l9, j19, k13));
            }
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            i = rand.nextInt(16) + 8;
            int height = worldIn.func_175645_m(pos.func_177982_a(i, 0, j = rand.nextInt(16) + 8)).func_177956_o() * 2;
            if (height < 1) {
                height = 1;
            }
            int k = rand.nextInt(height);
            blastemGen.func_180709_b(worldIn, rand, pos.func_177982_a(i, k, j));
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            for (int l3 = 0; l3 < this.scuronottePerChunk; ++l3) {
                int i8 = rand.nextInt(16) + 8;
                int l11 = rand.nextInt(16) + 8;
                BlockPos blockpos2 = worldIn.func_175645_m(pos.func_177982_a(i8, 0, l11));
                scuronotteGen.func_180709_b(worldIn, rand, blockpos2);
            }
        }
        for (int x = 8; x < 24; ++x) {
            for (int z = 8; z < 24; ++z) {
                BlockPos blockpos2 = worldIn.func_175645_m(pos.func_177982_a(x, 0, z));
                if (!(worldIn.func_180494_b(blockpos2) instanceof BiomeDefiled)) continue;
                corruptionPosGen.func_180709_b(worldIn, rand, blockpos2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos blockPos) {
        return 0x442F44;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos blockPos) {
        return 7035752;
    }

    public int func_76731_a(float temp) {
        return 0x220033;
    }

    public int getWaterColorMultiplier() {
        return 7035752;
    }
}

