/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.util;

import java.util.HashMap;
import java.util.Map;
import lykrast.defiledlands.common.block.BlockStoneDefiledDecoration;
import lykrast.defiledlands.common.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;

public class CorruptionRecipes {
    private static Map<IBlockState, IBlockState> corruptionMap = new HashMap<IBlockState, IBlockState>();

    public static void init() {
        CorruptionRecipes.register(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE), ModBlocks.stoneDefiled);
        CorruptionRecipes.register(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), ModBlocks.stoneDefiled);
        CorruptionRecipes.register(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), ModBlocks.stoneDefiled);
        CorruptionRecipes.register(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), ModBlocks.stoneDefiled);
        CorruptionRecipes.register(Blocks.field_150347_e, ModBlocks.stoneDefiled);
        CorruptionRecipes.register((Block)Blocks.field_150354_m, ModBlocks.sandDefiled);
        CorruptionRecipes.register(Blocks.field_150322_A, ModBlocks.sandstoneDefiled);
        CorruptionRecipes.register(Blocks.field_150346_d, ModBlocks.dirtDefiled);
        CorruptionRecipes.register((Block)Blocks.field_150349_c, ModBlocks.grassDefiled);
        CorruptionRecipes.register(Blocks.field_150351_n, ModBlocks.gravelDefiled);
        CorruptionRecipes.register(Blocks.field_150359_w, ModBlocks.glassObscure);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            CorruptionRecipes.register(Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)color), ModBlocks.glassObscure);
        }
        CorruptionRecipes.register(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.DEFAULT), ModBlocks.stoneDefiledDecoration.func_176223_P().func_177226_a(BlockStoneDefiledDecoration.VARIANT, (Comparable)((Object)BlockStoneDefiledDecoration.Variants.BRICKS)));
        CorruptionRecipes.register(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), ModBlocks.stoneDefiledDecoration.func_176223_P().func_177226_a(BlockStoneDefiledDecoration.VARIANT, (Comparable)((Object)BlockStoneDefiledDecoration.Variants.BRICKS_CRACKED)));
        CorruptionRecipes.register(Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY), ModBlocks.stoneDefiledDecoration.func_176223_P().func_177226_a(BlockStoneDefiledDecoration.VARIANT, (Comparable)((Object)BlockStoneDefiledDecoration.Variants.BRICKS_MOSSY)));
        CorruptionRecipes.register(Blocks.field_150341_Y, ModBlocks.stoneDefiledDecoration.func_176223_P().func_177226_a(BlockStoneDefiledDecoration.VARIANT, (Comparable)((Object)BlockStoneDefiledDecoration.Variants.MOSSY)));
        CorruptionRecipes.register(Blocks.field_150365_q, ModBlocks.hephaestiteOre);
        CorruptionRecipes.register(Blocks.field_150402_ci, ModBlocks.hephaestiteBlock);
        CorruptionRecipes.register(Blocks.field_150366_p, ModBlocks.umbriumOre);
        CorruptionRecipes.register(Blocks.field_150339_S, ModBlocks.umbriumBlock);
        CorruptionRecipes.register(Blocks.field_150482_ag, ModBlocks.scarliteOre);
        CorruptionRecipes.register(Blocks.field_150484_ah, ModBlocks.scarliteBlock);
    }

    public static IBlockState getCorrupted(IBlockState input) {
        return corruptionMap.get(input);
    }

    public static void register(IBlockState input, IBlockState output) {
        corruptionMap.put(input, output);
    }

    public static void register(Block input, Block output) {
        corruptionMap.put(input.func_176223_P(), output.func_176223_P());
    }

    public static void register(IBlockState input, Block output) {
        corruptionMap.put(input, output.func_176223_P());
    }

    public static void register(Block input, IBlockState output) {
        corruptionMap.put(input.func_176223_P(), output);
    }

    public static void unregister(IBlockState input) {
        IBlockState output = CorruptionRecipes.getCorrupted(input);
        CorruptionRecipes.unregister(input, output);
    }

    public static void unregister(IBlockState input, IBlockState output) {
        corruptionMap.remove(input, output);
    }

    public static Map<IBlockState, IBlockState> getMap() {
        return corruptionMap;
    }
}

