/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.boss;

import javax.annotation.Nullable;
import lykrast.defiledlands.common.entity.IEntityDefiled;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDestroyer
extends EntityMob
implements IEntityDefiled {
    public static final ResourceLocation LOOT = new ResourceLocation("defiledlands", "entities/the_destroyer");
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityDestroyer.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> LEAPING = EntityDataManager.func_187226_a(EntityDestroyer.class, (DataSerializer)DataSerializers.field_187198_h);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityDestroyer(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 2.4f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBigLeap(this, 1.2f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(LEAPING, (Object)false);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(LEAPING);
    }

    public void setLeaping(boolean val) {
        this.field_70180_af.func_187227_b(LEAPING, (Object)val);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isLeaping()) {
            this.setLeaping(false);
            if (!this.field_70170_p.field_72995_K) {
                boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, flag);
            }
        }
    }

    public int func_82143_as() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            entityIn.field_70181_x += (double)0.4f;
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        this.field_70703_bu = false;
        super.func_70636_d();
        if (this.getInvulTime() > 0) {
            this.field_70181_x = 0.01;
            for (int i1 = 0; i1 < 3; ++i1) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
        if (this.isLeaping() && this.func_70090_H()) {
            this.setLeaping(false);
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.func_184185_a(SoundEvents.field_187855_gD, 10.0f, 1.0f);
            }
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void ignite() {
        this.setInvulTime(200);
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
        Block block = blockStateIn.func_177230_c();
        if (EntityWither.func_181033_a((Block)block) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)blockStateIn)) {
            f = Math.min(2.0f, f);
        }
        return f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityDestroyer)) {
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= 180 && this.field_70725_aQ <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
        int i = this.field_70728_aV;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70725_aQ > 150 && this.field_70725_aQ % 5 == 0 && flag) {
                this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.08f)));
            }
            if (this.field_70725_aQ == 1) {
                this.func_184185_a(SoundEvents.field_187522_aL, 10.0f, 1.0f);
            }
        }
        this.field_70181_x = 0.01;
        if (this.field_70725_aQ >= 200) {
            if (!this.field_70170_p.field_72995_K) {
                if (flag) {
                    this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.2f)));
                }
                this.func_70106_y();
            }
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    private void dropExperience(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInvulTime(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityDestroyer.this.getInvulTime() > 0;
        }
    }

    static class AIBigLeap
    extends EntityAILeapAtTarget {
        EntityDestroyer field_75328_a;
        EntityLivingBase field_75326_b;
        float field_75327_c;

        public AIBigLeap(EntityDestroyer leapingEntity, float leapMotionYIn) {
            super((EntityLiving)leapingEntity, leapMotionYIn);
            this.field_75328_a = leapingEntity;
            this.field_75327_c = leapMotionYIn;
        }

        public boolean func_75250_a() {
            this.field_75326_b = this.field_75328_a.func_70638_az();
            if (this.field_75326_b == null || !this.field_75328_a.field_70122_E || this.field_75328_a.func_70090_H()) {
                return false;
            }
            double d0 = this.field_75328_a.func_70068_e((Entity)this.field_75326_b);
            return d0 >= 16.0 && d0 <= 1024.0 && this.field_75328_a.func_70681_au().nextInt(7) == 0;
        }

        public void func_75249_e() {
            double d0 = this.field_75326_b.field_70165_t - this.field_75328_a.field_70165_t;
            double d1 = this.field_75326_b.field_70161_v - this.field_75328_a.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            float enrage = (1.0f - this.field_75328_a.func_110143_aJ() / this.field_75328_a.func_110138_aP()) * 1.0f + 1.0f;
            if ((double)f >= 1.0E-4) {
                this.field_75328_a.field_70159_w += d0 / (double)f * 1.5 * (double)0.8f + this.field_75328_a.field_70159_w * 0.4;
                this.field_75328_a.field_70179_y += d1 / (double)f * 1.5 * (double)0.8f + this.field_75328_a.field_70179_y * 0.4;
            }
            this.field_75328_a.field_70159_w *= (double)enrage;
            this.field_75328_a.field_70179_y *= (double)enrage;
            this.field_75328_a.field_70181_x = this.field_75327_c;
            this.field_75328_a.setLeaping(true);
            this.field_75328_a.func_70671_ap().func_75651_a((Entity)this.field_75326_b, 10.0f, 10.0f);
        }
    }
}

