/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.PlateauUtil;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionDesertRiver;
import rtg.api.world.deco.collection.DecoCollectionMesa;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.VoronoiPlateauEffect;

public class RealisticBiomeVanillaMesaPlateau
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_150608_ab;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaMesaPlateau() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return biome;
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.1f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_CACTUS).set(true);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_2_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().ALLOW_PLATEAU_MODIFICATIONS).set(false);
        this.getConfig().addProperty(this.getConfig().PLATEAU_GRADIENT_BLOCK_LIST).set((Comparable[])PlateauUtil.getMesaPlateauBlocks());
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainRTGMesaPlateau(67.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaMesaPlateau(this.getConfig(), RealisticBiomeVanillaMesaPlateau.biome.field_76752_A, BlockUtil.getStateClay(EnumDyeColor.ORANGE), 0);
    }

    @Override
    public void rReplace(ChunkPrimer primer, int i, int j, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        this.rReplaceWithRiver(primer, i, j, x, y, depth, rtgWorld, noise, river, base);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionDesertRiver(this.getConfig()));
        this.addDecoCollection(new DecoCollectionMesa(this.getConfig()));
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76800_F = -999;
    }

    public class SurfaceVanillaMesaPlateau
    extends SurfaceBase {
        private int grassRaise;
        private IBlockState mixBlock;
        private IBlockState mix2Block;

        public SurfaceVanillaMesaPlateau(BiomeConfig config, IBlockState top, IBlockState fill, int grassHeight) {
            super(config, top, fill);
            this.grassRaise = 0;
            this.grassRaise = grassHeight;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), BlockUtil.getStateClay(EnumDyeColor.ORANGE));
            this.mix2Block = this.getConfigBlock(config.SURFACE_MIX_2_BLOCK.get(), Blocks.field_180395_cM.func_176223_P());
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.3f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    primer.func_177855_a(x, k, z, PlateauUtil.getPlateauBand(rtgWorld, RealisticBiomeVanillaMesaPlateau.this, i, k, j));
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (depth == 0) {
                        if (rand.nextInt(5) == 0) {
                            primer.func_177855_a(x, k, z, this.mix2Block);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (depth >= 4) continue;
                    primer.func_177855_a(x, k, z, this.fillerBlock);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                    if (rand.nextInt(r + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    if (rand.nextInt((int)((float)r / 2.0f) + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainRTGMesaPlateau
    extends TerrainBase {
        private static final float stepStart = 0.25f;
        private static final float stepFinish = 0.4f;
        private static final float stepHeight = 32.0f;
        final VoronoiPlateauEffect plateau = new VoronoiPlateauEffect();
        final int groundNoise;
        private float jitterWavelength = 30.0f;
        private float jitterAmplitude = 10.0f;
        private float bumpinessMultiplier = 0.05f;
        private float bumpinessWavelength = 10.0f;

        public TerrainRTGMesaPlateau(float base) {
            this.plateau.pointWavelength = 200.0f;
            this.base = base;
            this.groundNoise = 4;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int passedX, int passedY, float border, float river) {
            float f;
            float f2;
            ISimplexData2D jitterData = SimplexData2D.newDisk();
            rtgWorld.simplexInstance(1).multiEval2D((float)passedX / this.jitterWavelength, (float)passedY / this.jitterWavelength, jitterData);
            float x = (float)((double)passedX + jitterData.getDeltaX() * (double)this.jitterAmplitude);
            float y = (float)((double)passedY + jitterData.getDeltaY() * (double)this.jitterAmplitude);
            float bordercap = border * 3.5f - 2.5f;
            bordercap = f2 > 1.0f ? 1.0f : bordercap;
            float rivercap = 3.0f * river;
            rivercap = f > 1.0f ? 1.0f : rivercap;
            float bumpiness = rtgWorld.simplexInstance(2).noise2f(x / this.bumpinessWavelength, y / this.bumpinessWavelength) * this.bumpinessMultiplier;
            float simplex = this.plateau.added(rtgWorld, x, y) * bordercap * rivercap + bumpiness;
            float added = PlateauUtil.stepIncrease(simplex, 0.25f, 0.4f, 32.0f) / border;
            return TerrainRTGMesaPlateau.riverized(this.base + TerrainBase.groundNoise(x, y, (float)this.groundNoise, rtgWorld), river) + added;
        }
    }
}

