/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionExtremeHillsCommon;
import rtg.api.world.deco.collection.DecoCollectionExtremeHillsM;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.vanilla.RealisticBiomeVanillaExtremeHills;

public class RealisticBiomeVanillaExtremeHillsM
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185443_S;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaExtremeHillsM() {
        super(biome, RealisticBiomeBase.BeachType.STONE);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_FILLER_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new RealisticBiomeVanillaExtremeHills.RidgedExtremeHills(190.0f, 67.0f, 200.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaExtremeHillsM(this.getConfig(), RealisticBiomeVanillaExtremeHillsM.biome.field_76752_A, RealisticBiomeVanillaExtremeHillsM.biome.field_76753_B, Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 60.0f, -0.14f, 14.0f, 0.25f);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionExtremeHillsM(this.getConfig()));
        this.addDecoCollection(new DecoCollectionExtremeHillsCommon(this.getConfig()));
    }

    public static class SurfaceVanillaExtremeHillsM
    extends SurfaceBase {
        private IBlockState mixBlockTop;
        private IBlockState mixBlockFill;
        private float width;
        private float height;
        private float smallW;
        private float smallS;

        public SurfaceVanillaExtremeHillsM(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFill, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.mixBlockTop = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mixTop);
            this.mixBlockFill = this.getConfigBlock(config.SURFACE_MIX_FILLER_BLOCK.get(), mixFill);
            this.width = mixWidth;
            this.height = mixHeight;
            this.smallW = smallWidth;
            this.smallS = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) + simplex.noise2f((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlockTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.mixBlockFill);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaExtremeHillsM
    extends TerrainBase {
        private float start;
        private float height;
        private float width;

        public TerrainVanillaExtremeHillsM(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaExtremeHillsM.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, this.base - 62.0f);
        }
    }
}

