/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.traverse;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.traverse.RealisticBiomeTRAVBase;

public class RealisticBiomeTRAVAridHighland
extends RealisticBiomeTRAVBase {
    public RealisticBiomeTRAVAridHighland(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_2_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainHLAdirondacks(230.0f, 60.0f, 88.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, this.baseBiome().field_76752_A, 0.6f, Blocks.field_150349_c.func_176223_P(), -0.4f);
    }

    public static class SurfaceVanillaForest
    extends SurfaceBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private IBlockState mixBlock;
        private float mixHeight;
        private IBlockState mix2Block;
        private float mix2Height;

        public SurfaceVanillaForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixHeight, IBlockState mix2, float mix2Height) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixHeight;
            this.mix2Block = this.getConfigBlock(config.SURFACE_MIX_2_BLOCK.get(), mix2);
            this.mix2Height = mix2Height;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    float mixNoise = simplex.noise2f((float)i / 12.0f, (float)j / 12.0f);
                    if (mixNoise < this.mix2Height) {
                        primer.func_177855_a(x, k, z, this.mix2Block);
                        m = true;
                        continue;
                    }
                    if (mixNoise > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.mix2Block);
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainHLAdirondacks
    extends TerrainBase {
        private float width;
        private float strength;
        private float terrainHeight;
        private int wavelength = 40;
        private ISimplexData2D jitter = SimplexData2D.newDisk();
        private double amplitude = 10.0;

        public TerrainHLAdirondacks(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.terrainHeight = height;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            rtgWorld.simplexInstance(1).multiEval2D((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
            int pX = (int)Math.round((double)x + this.jitter.getDeltaX() * this.amplitude);
            int pY = (int)Math.round((double)y + this.jitter.getDeltaY() * this.amplitude);
            x = pX;
            y = pY;
            return TerrainHLAdirondacks.terrainLonelyMountain(x, y, rtgWorld, river, this.strength, this.width, this.terrainHeight);
        }
    }
}

