/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.novamterram;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.api.world.terrain.heighteffect.MountainsWithPassesEffect;
import rtg.world.biome.realistic.novamterram.RealisticBiomeNTBase;

public abstract class RealisticBiomeNTBaseMountain
extends RealisticBiomeNTBase {
    public RealisticBiomeNTBaseMountain(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType, @Nonnull RealisticBiomeBase.BeachType beachType) {
        super(baseBiome, riverType, beachType);
    }

    public RealisticBiomeNTBaseMountain(@Nonnull Biome baseBiome) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseMountain(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType) {
        this(baseBiome, riverType, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseMountain(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.BeachType beachType) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, beachType);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPMountainPeaks(120.0f, 100.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPMountainPeaks(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.getMixBlock1(), this.baseBiome().field_76753_B, 80.0f, -0.15f, 10.0f, 0.5f);
    }

    public static class SurfaceBOPMountainPeaks
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceBOPMountainPeaks(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPMountainPeaks
    extends TerrainBase {
        private float width;
        private float strength;
        private float terrainHeight;
        private float spikeWidth = 30.0f;
        private float spikeHeight = 50.0f;
        private HeightEffect heightEffect;

        public TerrainBOPMountainPeaks(float mountainWidth, float mountainStrength) {
            this(mountainWidth, mountainStrength, 90.0f);
        }

        public TerrainBOPMountainPeaks(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.terrainHeight = height;
            MountainsWithPassesEffect mountainEffect = new MountainsWithPassesEffect();
            mountainEffect.mountainHeight = this.strength;
            mountainEffect.mountainWavelength = this.width;
            mountainEffect.spikeHeight = this.spikeHeight;
            mountainEffect.spikeWavelength = this.spikeWidth;
            this.heightEffect = new JitterEffect(7.0f, 10.0f, mountainEffect);
            this.heightEffect = new JitterEffect(3.0f, 6.0f, this.heightEffect);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPMountainPeaks.riverized(this.heightEffect.added(rtgWorld, x, y) + this.terrainHeight, river);
        }
    }
}

