/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.surface;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;

public class SurfaceRiverOasis
extends SurfaceBase {
    public SurfaceRiverOasis(BiomeConfig config) {
        super(config, Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P());
    }

    @Override
    public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        IBlockState blockState;
        int highestY;
        float cutOffScale = rtgWorld.getGeneratorSettings().riverCutOffScale;
        float cutOffAmplitude = rtgWorld.getGeneratorSettings().riverCutOffAmpl;
        for (highestY = 255; highestY > 0 && (blockState = primer.func_177856_a(x, highestY, z)).func_177230_c() == Blocks.field_150350_a; --highestY) {
        }
        float amplitude = 0.05f;
        float noiseValue = rtgWorld.simplexInstance(0).noise2f((float)i / 8.0f, (float)j / 8.0f) * amplitude / 1.0f + rtgWorld.simplexInstance(1).noise2f((float)i / 3.0f, (float)j / 3.0f) * amplitude / 2.0f;
        float noiseNeg = rtgWorld.simplexInstance(2).noise2f((float)i / cutOffScale, (float)j / cutOffScale) * cutOffAmplitude;
        noiseValue -= noiseNeg;
        if (highestY > 62) {
            noiseValue -= (float)(highestY - 62) * 0.083333336f;
        }
        if ((double)river > 0.7 && (double)(river + noiseValue) > 0.85) {
            for (int k = 255; k > -1; --k) {
                blockState = primer.func_177856_a(x, k, z);
                if (blockState.func_177230_c() == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (blockState.func_185904_a() == Material.field_151586_h) continue;
                if (++depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (depth < 4) {
                    primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
                    continue;
                }
                if (depth <= 4) continue;
                return;
            }
        }
    }
}

