/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature.tree.rtg;

import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rtg.api.util.BlockUtil;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;

public class TreeRTGCocosNucifera
extends TreeRTG {
    private static int leavesLength = 133;
    private static int[] leaves = new int[]{1, 0, 0, 2, 0, 0, 3, -1, 0, 3, -2, 0, -1, 0, 0, -2, 0, 0, -3, -1, 0, -3, -2, 0, 0, 0, 1, 0, 0, 2, 0, -1, 3, 0, -2, 3, 0, 0, -1, 0, 0, -2, 0, -1, -3, 0, -2, -3, 0, 1, 0, 1, 1, 1, -1, 1, -1, -1, 1, 1, 1, 1, -1, 1, 2, 0, -1, 2, 0, 0, 2, 1, 0, 2, -1, 2, 3, 0, 3, 3, 0, 4, 2, 0, -2, 3, 0, -3, 3, 0, -4, 2, 0, 0, 3, 2, 0, 3, 3, 0, 2, 4, 0, 3, -2, 0, 3, -3, 0, 2, -4, 2, 2, -2, -2, 2, 2, -2, 2, -2, 2, 2, 2, 3, 2, -3, -3, 2, 3, -3, 2, -3, 3, 2, 3};
    private static int cocoasLength = 16;
    private static int[] cocoas = new int[]{2, 0, -2, 1, 1, 1, -2, 0, 0, 0, -2, -1, 3, -1, -2, 0};
    protected IBlockState trunkLog;

    public TreeRTGCocosNucifera() {
        this.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE));
        this.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.JUNGLE));
        this.trunkSize = 8;
        this.crownSize = 7;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.isGroundValid(world, pos, true)) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.trunkLog = this.getTrunkLog(this.logBlock);
        double horDir = this.getRandomDir(rand);
        float verDir = 0.3f + rand.nextFloat() * 0.4f;
        float length = this.trunkSize + this.crownSize;
        float posX = x;
        float posY = y;
        float posZ = z;
        float c = 0.0f;
        float loss = 0.0f;
        if (verDir < 0.0f) {
            verDir = -verDir;
        }
        float velY = 1.0f - verDir;
        if (verDir > 1.0f) {
            verDir = 1.0f - (verDir - 1.0f);
        }
        float velX = (float)Math.cos(horDir * Math.PI / 180.0) * verDir;
        float velZ = (float)Math.sin(horDir * Math.PI / 180.0) * verDir;
        while (c < length) {
            this.placeLogBlock(world, new BlockPos((int)posX, (int)posY, (int)posZ), this.trunkLog, this.generateFlag);
            if (c < length - 3.0f) {
                loss = Math.abs(velX) + Math.abs(velZ);
                posX += (velX *= 0.9f);
                posZ += (velZ *= 0.9f);
                posY += (velY += (loss -= Math.abs(velX) + Math.abs(velZ)));
            } else {
                posY += velY;
            }
            c += 1.0f;
        }
        x = (int)posX;
        y = (int)posY - 1;
        z = (int)posZ;
        if (!this.noLeaves) {
            for (int j = 0; j < leavesLength; j += 3) {
                this.placeLeavesBlock(world, new BlockPos(x + leaves[j], y + leaves[j + 1], z + leaves[j + 2]), this.leavesBlock, this.generateFlag);
            }
        }
        for (int k = 0; k < cocoasLength; k += 4) {
            if (rand.nextInt(20) != 0) continue;
            world.func_180501_a(new BlockPos(x + cocoas[k + 1], y + cocoas[k + 2], z + cocoas[k + 3]), Blocks.field_150375_by.func_176223_P(), this.generateFlag);
        }
        return true;
    }

    public double getRandomDir(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return -180.0;
            }
            case 1: {
                return -90.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return 90.0;
            }
        }
        return 0.0;
    }
}

