/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.item;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.BountifulAPI;
import ejektaflex.bountiful.api.data.IBountyData;
import ejektaflex.bountiful.api.enum.EnumBountyRarity;
import ejektaflex.bountiful.api.ext.ExtMiscKt;
import ejektaflex.bountiful.api.item.IItemBounty;
import ejektaflex.bountiful.api.logic.BountyNBT;
import ejektaflex.bountiful.api.stats.BountifulStats;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.logic.BountyChecker;
import ejektaflex.bountiful.logic.error.BountyCreationException;
import ejektaflex.compat.FacadeGameStages;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0010J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0014H\u0016J2\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0016J \u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010.\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u00062"}, d2={"Lejektaflex/bountiful/item/ItemBounty;", "Lnet/minecraft/item/Item;", "Lejektaflex/bountiful/api/item/IItemBounty;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "cashIn", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "atBoard", "ensureBounty", "rarity", "Lejektaflex/bountiful/api/enum/EnumBountyRarity;", "ensureTimerStarted", "getBountyData", "Lejektaflex/bountiful/data/BountyData;", "getItemStackDisplayName", "getRarity", "Lnet/minecraft/item/EnumRarity;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "playerIn", "handIn", "onUpdate", "entityIn", "Lnet/minecraft/entity/Entity;", "itemSlot", "", "isSelected", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "tickBoardTime", "tickNumber", "amount", "key", "tryExpireBountyTime", "Bountiful"})
public final class ItemBounty
extends Item
implements IItemBounty {
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        if (stack.func_77942_o()) {
            BountyData bountyData;
            BountyData $receiver = bountyData = new BountyData();
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
            $receiver.deserializeNBT(nBTTagCompound);
            BountyData bounty = bountyData;
            World world = worldIn;
            if (world == null) {
                Intrinsics.throwNpe();
            }
            List<String> bountyTipInfo = bounty.tooltipInfo(world, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
            for (String line : bountyTipInfo) {
                tooltip.add(line);
            }
        }
    }

    @Override
    @NotNull
    public BountyData getBountyData(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemBounty) {
            BountyData bountyData;
            BountyData $receiver = bountyData = new BountyData();
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
            $receiver.deserializeNBT(nBTTagCompound);
            return bountyData;
        }
        throw (Throwable)new Exception(stack.func_82833_r() + " is not an ItemBounty or has no NBT data!");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public EnumRarity func_77613_e(@NotNull ItemStack stack) {
        EnumRarity enumRarity;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if (nBTTagCompound.func_74764_b(BountyNBT.Rarity.getKey())) {
                NBTTagCompound nBTTagCompound2 = stack.func_77978_p();
                if (nBTTagCompound2 == null) {
                    Intrinsics.throwNpe();
                }
                enumRarity = EnumBountyRarity.Companion.getRarityFromInt(nBTTagCompound2.func_74762_e(BountyNBT.Rarity.getKey())).getItemRarity();
                return enumRarity;
            }
        }
        EnumRarity enumRarity2 = super.func_77613_e(stack);
        enumRarity = enumRarity2;
        Intrinsics.checkExpressionValueIsNotNull((Object)enumRarity2, (String)"super.getRarity(stack)");
        return enumRarity;
    }

    private final boolean tickNumber(ItemStack stack, int amount, String key) {
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if (nBTTagCompound.func_74764_b(key)) {
                int time;
                NBTTagCompound nBTTagCompound2 = stack.func_77978_p();
                if (nBTTagCompound2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((time = nBTTagCompound2.func_74762_e(key)) > 0) {
                    time -= amount;
                }
                if (time < 0) {
                    time = 0;
                }
                NBTTagCompound nBTTagCompound3 = stack.func_77978_p();
                if (nBTTagCompound3 == null) {
                    Intrinsics.throwNpe();
                }
                nBTTagCompound3.func_74768_a(key, time);
                return time <= 0;
            }
        }
        return true;
    }

    @Override
    public void tryExpireBountyTime(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if (nBTTagCompound.func_74764_b(BountyNBT.BountyTime.getKey())) {
                NBTTagCompound nBTTagCompound2 = stack.func_77978_p();
                if (nBTTagCompound2 == null) {
                    Intrinsics.throwNpe();
                }
                nBTTagCompound2.func_74768_a(BountyNBT.BountyTime.getKey(), 0);
            }
        }
    }

    @Override
    public boolean tickBoardTime(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.tickNumber(stack, (int)20L, BountyNBT.BoardStamp.getKey());
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        StringBuilder stringBuilder = new StringBuilder().append(super.func_77653_i(stack));
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if (nBTTagCompound.func_74764_b(BountyNBT.Rarity.getKey())) {
                NBTTagCompound nBTTagCompound2 = stack.func_77978_p();
                if (nBTTagCompound2 == null) {
                    Intrinsics.throwNpe();
                }
                EnumBountyRarity rarity = EnumBountyRarity.Companion.getRarityFromInt(nBTTagCompound2.func_74762_e(BountyNBT.Rarity.getKey()));
                String localizedRarity = I18n.func_135052_a((String)("bountiful.rarity." + rarity.name()), (Object[])new Object[0]);
                string = " (" + localizedRarity + ')';
                return stringBuilder.append(string).toString();
            }
        }
        string = "";
        return stringBuilder.append(string).toString();
    }

    public final void ensureTimerStarted(@NotNull ItemStack stack, @NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        if (stack.func_77973_b() instanceof ItemBounty && stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if (!nBTTagCompound.func_74764_b(BountyNBT.BountyStamp.getKey())) {
                NBTTagCompound nBTTagCompound2 = stack.func_77978_p();
                if (nBTTagCompound2 == null) {
                    Intrinsics.throwNpe();
                }
                nBTTagCompound2.func_74772_a(BountyNBT.BountyStamp.getKey(), worldIn.func_82737_E());
            }
        }
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @Nullable Entity entityIn, int itemSlot, boolean isSelected) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        if (worldIn.func_82737_E() % 20L == 1L) {
            this.ensureTimerStarted(stack, worldIn);
        }
    }

    @Override
    public void ensureBounty(@NotNull ItemStack stack, @NotNull World worldIn, @Nullable EnumBountyRarity rarity) {
        IBountyData iBountyData;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        try {
            iBountyData = BountifulAPI.INSTANCE.createBountyData(worldIn, rarity);
        }
        catch (BountyCreationException e) {
            return;
        }
        IBountyData data = iBountyData;
        if (stack.func_77973_b() instanceof ItemBounty) {
            if (!stack.func_77942_o() && data != null) {
                iBountyData = data.serializeNBT();
                ItemStack itemStack = stack;
                NBTTagCompound $receiver = (NBTTagCompound)iBountyData;
                $receiver.func_82580_o(BountyNBT.BountyStamp.getKey());
                $receiver.func_74772_a(BountyNBT.BoardStamp.getKey(), worldIn.func_82737_E());
                IBountyData iBountyData2 = iBountyData;
                itemStack.func_77982_d((NBTTagCompound)iBountyData2);
            }
        } else {
            throw (Throwable)new Exception(stack.func_82833_r() + " is not an ItemBounty, so you cannot generate bounty data for it!");
        }
    }

    public final boolean cashIn(@NotNull EntityPlayer player, @NotNull EnumHand hand, boolean atBoard) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack bountyItem = player.func_184586_b(hand);
        if (!bountyItem.func_77942_o()) {
            ItemStack itemStack = player.func_184586_b(hand);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"player.getHeldItem(hand)");
            World world = player.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
            IItemBounty.DefaultImpls.ensureBounty$default(this, itemStack, world, null, 4, null);
            return false;
        }
        NonNullList inv = player.field_71071_by.field_70462_a;
        Object object = new BountyData();
        BountyData $receiver = object;
        ItemStack itemStack = bountyItem;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"bountyItem");
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"bountyItem.tagCompound!!");
        $receiver.deserializeNBT(nBTTagCompound);
        BountyData bounty = object;
        if (Bountiful.INSTANCE.getConfig().isRunningGameStages() && !(object = (Collection)FacadeGameStages.INSTANCE.stagesStillNeededFor(player, bounty)).isEmpty()) {
            ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.tooltip.requirements");
            return false;
        }
        World world = player.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
        if (bounty.hasExpired(world)) {
            ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.bounty.expired");
            return false;
        }
        NonNullList nonNullList = inv;
        Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList, (String)"inv");
        List<ItemStack> list = BountyChecker.INSTANCE.hasItems(player, (NonNullList<ItemStack>)nonNullList, bounty);
        if (list == null) {
            return false;
        }
        List<ItemStack> invItemsAffected = list;
        boolean entitiesFulfilled = BountyChecker.INSTANCE.hasEntitiesFulfilled(bounty);
        if (!entitiesFulfilled) {
            ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.requirements.mobs.needed");
            return false;
        }
        if (!atBoard && Bountiful.INSTANCE.getConfig().getCashInAtBountyBoard()) {
            ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.requirements.met");
            bl = false;
        } else {
            ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.bounty.fulfilled");
            BountyChecker.INSTANCE.takeItems(player, (NonNullList<ItemStack>)inv, bounty, invItemsAffected);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            BountyChecker.INSTANCE.rewardItems(player, bounty, bountyItem);
            EnumBountyRarity bountyRarity = EnumBountyRarity.Companion.getRarityFromInt(bounty.getRarity());
            player.func_71029_a((StatBase)BountifulStats.INSTANCE.getBountiesCompleted());
            player.func_71029_a((StatBase)bountyRarity.getStat());
            player.func_71023_q(bountyRarity.getXp());
            bl = true;
        }
        return bl;
    }

    public static /* synthetic */ boolean cashIn$default(ItemBounty itemBounty, EntityPlayer entityPlayer, EnumHand enumHand, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return itemBounty.cashIn(entityPlayer, enumHand, bl);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        if (worldIn.field_72995_K) {
            ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
            return actionResult;
        }
        this.cashIn(playerIn, handIn, false);
        ActionResult actionResult = super.func_77659_a(worldIn, playerIn, handIn);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(worldIn, playerIn, handIn)");
        return actionResult;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkParameterIsNotNull((Object)oldStack, (String)"oldStack");
        Intrinsics.checkParameterIsNotNull((Object)newStack, (String)"newStack");
        return slotChanged;
    }
}

