/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal.util;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.TypeParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class NodeUtil {
    public static void forChildren(Node node, Consumer<Node> nodeConsumer) {
        NodeUtil.forChildren(node, nodeConsumer, Node.class);
    }

    public static <T> void forChildren(Node node, Consumer<T> nodeConsumer, Class<T> ofClass) {
        for (Node child : node.getChildNodes()) {
            if (ofClass.isAssignableFrom(child.getClass())) {
                nodeConsumer.accept(child);
            }
            NodeUtil.forChildren(child, nodeConsumer, ofClass);
        }
    }

    public static <ResultType> List<ResultType> getFromList(Node node, Function<Node, List<ResultType>> getter) {
        ArrayList<ResultType> parameters = new ArrayList<ResultType>();
        while (node != null) {
            List<ResultType> extra = getter.apply(node);
            if (extra != null && !extra.isEmpty()) {
                parameters.addAll(extra);
            }
            node = node.getParentNode().orElse(null);
        }
        return parameters;
    }

    public static <ResultType> List<ResultType> getFromSingle(Node node, Function<Node, ResultType> getter) {
        ArrayList<ResultType> parameters = null;
        while (node != null) {
            ResultType extra = getter.apply(node);
            if (extra != null) {
                if (parameters == null) {
                    parameters = new ArrayList<ResultType>();
                }
                parameters.add(extra);
            }
            node = node.getParentNode().orElse(null);
        }
        return parameters;
    }

    public static List<TypeParameter> getTypeParameters(Node node) {
        return NodeUtil.getFromList(node, NodeUtil::getTypeParametersOnly);
    }

    private static NodeList<TypeParameter> getTypeParametersOnly(Node node) {
        if (node instanceof NodeWithTypeParameters) {
            return ((NodeWithTypeParameters)node).getTypeParameters();
        }
        return null;
    }

    public static <T extends Node> T getParentNode(Node node, Class<T> target) {
        while ((node = (Node)node.getParentNode().orElse(null)) != null && !target.isAssignableFrom(node.getClass())) {
        }
        return (T)node;
    }

    public static String qualifiedName(Name name) {
        return name.asString();
    }

    private NodeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

