/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.Parameter;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.TypeVariable;
import org.minimallycorrect.javatransformer.internal.ResolutionContext;
import org.minimallycorrect.javatransformer.internal.util.AnnotationParser;
import org.minimallycorrect.javatransformer.internal.util.CachingSupplier;
import org.minimallycorrect.javatransformer.internal.util.TypeUtil;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;

public class MethodDescriptor {
    private final List<TypeVariable> typeVariables;
    private final List<Parameter> parameters;
    private final Type returnType;

    public MethodDescriptor(List<TypeVariable> typeVariables, List<Parameter> parameters, Type returnType) {
        this.typeVariables = typeVariables;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public MethodDescriptor(@NonNull String descriptor, @Nullable String signature) {
        this(descriptor, signature, null);
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
    }

    public MethodDescriptor(MethodNode node) {
        this(MethodDescriptor.getTypeVariables(node.signature), MethodDescriptor.getParameters(node), MethodDescriptor.getReturnType(node.desc, node.signature));
    }

    public MethodDescriptor(String descriptor, @Nullable String signature, @Nullable List<String> parameterNames) {
        this(MethodDescriptor.getTypeVariables(signature), MethodDescriptor.getParameters(descriptor, signature, parameterNames, null, null), MethodDescriptor.getReturnType(descriptor, signature));
    }

    private static List<TypeVariable> getTypeVariables(@Nullable String signature) {
        if (signature == null) {
            return Collections.emptyList();
        }
        String before = MethodDescriptor.before('(', signature);
        String typeArguments = ResolutionContext.extractGeneric(before);
        if (typeArguments == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>();
        int pos = 0;
        int start = 0;
        while (pos < typeArguments.length()) {
            char c = typeArguments.charAt(pos++);
            switch (c) {
                case ':': {
                    String name = typeArguments.substring(start, pos);
                    String bounds = TypeUtil.readType(typeArguments, pos, true);
                    pos += bounds.length();
                    list.add(new TypeVariable(name, Type.ofSignature(bounds)));
                }
            }
        }
        return list;
    }

    private static Type getReturnType(String descriptor, @Nullable String signature) {
        String returnDescriptor = MethodDescriptor.after(')', descriptor);
        String returnSignature = null;
        if (signature != null) {
            returnSignature = MethodDescriptor.after(')', signature);
        }
        return new Type(returnDescriptor, returnSignature);
    }

    private static List<Parameter> getParameters(MethodNode node) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        if (node.parameters != null) {
            for (ParameterNode param : node.parameters) {
                parameterNames.add(param.name);
            }
        }
        return MethodDescriptor.getParameters(node.desc, node.signature, parameterNames, node.invisibleParameterAnnotations, node.visibleParameterAnnotations);
    }

    private static List<Parameter> getParameters(String descriptor, @Nullable String signature, @Nullable List<String> parameterNames, @Nullable List<AnnotationNode>[] invisibleAnnotations, @Nullable List<AnnotationNode>[] visibleAnnotations) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List<Type> parameterTypes = Type.listOf(MethodDescriptor.getParameters(descriptor), MethodDescriptor.getParameters(signature));
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String name = parameterNames == null || i >= parameterNames.size() ? null : parameterNames.get(i);
            CachingSupplier<List> annotationSupplier = null;
            if (invisibleAnnotations != null && invisibleAnnotations.length > 0 || visibleAnnotations != null && visibleAnnotations.length > 0) {
                int j = i;
                annotationSupplier = CachingSupplier.of(() -> {
                    ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                    if (invisibleAnnotations != null && j < invisibleAnnotations.length) {
                        for (AnnotationNode node : invisibleAnnotations[j]) {
                            annotations.add(AnnotationParser.annotationFromAnnotationNode(node));
                        }
                    }
                    if (visibleAnnotations != null && j < visibleAnnotations.length) {
                        for (AnnotationNode node : visibleAnnotations[j]) {
                            annotations.add(AnnotationParser.annotationFromAnnotationNode(node));
                        }
                    }
                    return annotations;
                });
            }
            parameters.add(Parameter.of(parameterTypes.get(i), name, annotationSupplier));
        }
        return parameters;
    }

    @Nullable
    private static String getParameters(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        return MethodDescriptor.before(')', MethodDescriptor.after('(', descriptor));
    }

    private static String before(char c, String in) {
        int index = in.indexOf(c);
        if (index == -1) {
            throw new TransformationException("Could not find '" + c + "' in '" + in + "'");
        }
        return in.substring(0, index);
    }

    private static String after(char c, String in) {
        int index = in.indexOf(c);
        if (index == -1) {
            throw new TransformationException("Could not find '" + c + "' in '" + in + "'");
        }
        return in.substring(index + 1, in.length());
    }

    public MethodDescriptor withTypeVariables(List<TypeVariable> typeVariables) {
        return new MethodDescriptor(typeVariables, this.parameters, this.returnType);
    }

    public MethodDescriptor withParameters(List<Parameter> parameters) {
        return new MethodDescriptor(this.typeVariables, parameters, this.returnType);
    }

    public MethodDescriptor withReturnType(Type returnType) {
        return new MethodDescriptor(this.typeVariables, this.parameters, returnType);
    }

    public void saveTo(MethodNode node) {
        node.desc = this.getDescriptor();
        node.signature = this.getSignature();
    }

    public String getDescriptor() {
        StringBuilder desc = new StringBuilder("(");
        for (Parameter parameter : this.parameters) {
            desc.append(parameter.type.descriptor);
        }
        desc.append(")").append(this.returnType.descriptor);
        return desc.toString();
    }

    @Nullable
    private String getSignature() {
        boolean any = false;
        StringBuilder signature = new StringBuilder();
        List<TypeVariable> typeVariables = this.getTypeVariables();
        if (!typeVariables.isEmpty()) {
            signature.append('<');
            typeVariables.forEach(signature::append);
            signature.append('>');
        }
        signature.append("(");
        for (Parameter parameter : this.parameters) {
            String generic = parameter.type.signature;
            if (generic == null) {
                generic = parameter.type.descriptor;
            } else {
                any = true;
            }
            signature.append(generic);
        }
        signature.append(")");
        String generic = this.returnType.signature;
        if (generic == null) {
            generic = this.returnType.descriptor;
        } else {
            any = true;
        }
        signature.append(generic);
        if (any) {
            return signature.toString();
        }
        return null;
    }

    public List<TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return "MethodDescriptor(typeVariables=" + this.getTypeVariables() + ", parameters=" + this.getParameters() + ", returnType=" + this.getReturnType() + ")";
    }
}

