/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api.code;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.minimallycorrect.javatransformer.api.TransformationException;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.api.code.IntermediateValue;

public interface CodeFragment {
    public void insert(@NonNull CodeFragment var1, @NonNull InsertionPosition var2, @NonNull InsertionOptions var3);

    default public void insert(@NonNull CodeFragment codeFragment, @NonNull InsertionPosition position) {
        if (codeFragment == null) {
            throw new NullPointerException("codeFragment");
        }
        if (position == null) {
            throw new NullPointerException("position");
        }
        this.insert(codeFragment, position, new InsertionOptions());
    }

    default public <T extends CodeFragment> List<T> findFragments(Class<T> fragmentType) {
        if (fragmentType.isAssignableFrom(this.getClass())) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    public ExecutionOutcome getExecutionOutcome();

    @NonNull
    public List<IntermediateValue> getInputTypes();

    @NonNull
    public List<IntermediateValue> getOutputTypes();

    public static class UnreachableInsertionException
    extends TransformationException {
        public UnreachableInsertionException(CodeFragment fragment, InsertionPosition position) {
            super("Can't insert into '" + fragment + "' at position " + (Object)((Object)position) + " as the code would be unreachable");
        }
    }

    public static class TypeMismatchException
    extends TransformationException {
        final Class<? extends CodeFragment> expected;
        final Class<? extends CodeFragment> actual;

        public TypeMismatchException(Class<? extends CodeFragment> expected, @NonNull CodeFragment actual) {
            super("Expected CodeFragment of type " + expected + ". Actual type " + actual.getClass());
            if (actual == null) {
                throw new NullPointerException("actual");
            }
            this.expected = expected;
            this.actual = actual.getClass();
        }
    }

    public static final class ExecutionOutcome {
        public final boolean canFallThrough;
        public final boolean canThrow;
        public final boolean canReturn;

        public ExecutionOutcome(boolean canFallThrough, boolean canThrow, boolean canReturn) {
            this.canFallThrough = canFallThrough;
            this.canThrow = canThrow;
            this.canReturn = canReturn;
        }

        public String toString() {
            return "CodeFragment.ExecutionOutcome(canFallThrough=" + this.canFallThrough + ", canThrow=" + this.canThrow + ", canReturn=" + this.canReturn + ")";
        }
    }

    public static class InsertionOptions {
        public static InsertionOptions DEFAULT = new InsertionOptions();
        public boolean convertReturnToOutputTypes = true;
        public boolean convertReturnCallToReturnInstruction = true;
        public boolean eliminateDeadCode = true;

        public InsertionOptions(boolean convertReturnToOutputTypes, boolean convertReturnCallToReturnInstruction, boolean eliminateDeadCode) {
            this.convertReturnToOutputTypes = convertReturnToOutputTypes;
            this.convertReturnCallToReturnInstruction = convertReturnCallToReturnInstruction;
            this.eliminateDeadCode = eliminateDeadCode;
        }

        public boolean isConvertReturnToOutputTypes() {
            return this.convertReturnToOutputTypes;
        }

        public boolean isConvertReturnCallToReturnInstruction() {
            return this.convertReturnCallToReturnInstruction;
        }

        public boolean isEliminateDeadCode() {
            return this.eliminateDeadCode;
        }

        public InsertionOptions() {
        }

        public InsertionOptions withConvertReturnToOutputTypes(boolean convertReturnToOutputTypes) {
            return this.convertReturnToOutputTypes == convertReturnToOutputTypes ? this : new InsertionOptions(convertReturnToOutputTypes, this.convertReturnCallToReturnInstruction, this.eliminateDeadCode);
        }

        public InsertionOptions withConvertReturnCallToReturnInstruction(boolean convertReturnCallToReturnInstruction) {
            return this.convertReturnCallToReturnInstruction == convertReturnCallToReturnInstruction ? this : new InsertionOptions(this.convertReturnToOutputTypes, convertReturnCallToReturnInstruction, this.eliminateDeadCode);
        }

        public InsertionOptions withEliminateDeadCode(boolean eliminateDeadCode) {
            return this.eliminateDeadCode == eliminateDeadCode ? this : new InsertionOptions(this.convertReturnToOutputTypes, this.convertReturnCallToReturnInstruction, eliminateDeadCode);
        }
    }

    @FunctionalInterface
    public static interface HasName {
        @NonNull
        public String getName();
    }

    @FunctionalInterface
    public static interface HasContainingClassType {
        @NonNull
        public Type getContainingClassType();
    }

    public static interface Body
    extends CodeFragment {
    }

    public static interface New
    extends CodeFragment {
    }

    public static interface Return
    extends CodeFragment {
    }

    public static interface FieldStore
    extends FieldAccess {
    }

    public static interface FieldLoad
    extends FieldAccess {
    }

    public static interface FieldAccess
    extends CodeFragment,
    HasContainingClassType,
    HasName {
    }

    public static interface MethodCall
    extends CodeFragment,
    HasContainingClassType,
    HasName {
    }

    public static enum InsertionPosition {
        BEFORE,
        OVERWRITE,
        AFTER;

    }
}

