/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.javatransformer.api;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.minimallycorrect.javatransformer.internal.util.JVMUtil;
import org.minimallycorrect.javatransformer.internal.util.Joiner;

public class ClassPath {
    private final HashSet<String> classes = new HashSet();
    private final HashSet<Path> inputPaths = new HashSet();
    private final ClassPath parent;
    private boolean loaded;

    private ClassPath(@Nullable ClassPath parent) {
        this.parent = parent;
    }

    public ClassPath() {
        this((ClassPath)null);
    }

    public ClassPath(Collection<Path> paths) {
        this();
        this.addPaths(paths);
    }

    public ClassPath createChildWithExtraPaths(Collection<Path> paths) {
        ClassPath searchPath = new ClassPath(this);
        searchPath.addPaths(paths);
        return searchPath;
    }

    public String toString() {
        this.initialise();
        return "[" + this.parent.toString() + ", " + this.inputPaths + " classes:\n" + Joiner.on("\n").join(this.classes.stream().sorted()) + "]";
    }

    @Contract(value="null -> fail")
    public boolean classExists(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        this.initialise();
        return this.classes.contains(className) || this.parent != null && this.parent.classExists(className);
    }

    @Contract(value="null -> fail")
    public boolean addPath(@NonNull Path path) {
        boolean add;
        if (path == null) {
            throw new NullPointerException("path");
        }
        boolean bl = add = !this.parentHasPath(path = path.normalize().toAbsolutePath()) && this.inputPaths.add(path);
        if (add && this.loaded) {
            this.loadPath(path);
        }
        return add;
    }

    @Contract(value="null -> fail")
    public void addPaths(@NonNull Collection<Path> paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        for (Path path : paths) {
            this.addPath(path);
        }
    }

    private boolean parentHasPath(Path path) {
        ClassPath parent = this.parent;
        return parent != null && (parent.inputPaths.contains(path) || parent.parentHasPath(path));
    }

    private void findPaths(ZipEntry e, ZipInputStream zis) {
        String entryName = e.getName();
        if (entryName.endsWith(".java")) {
            this.findJavaPaths(zis);
        }
        if (entryName.endsWith(".class")) {
            this.classes.add(JVMUtil.fileNameToClassName(entryName));
        }
    }

    private void findJavaPaths(final ZipInputStream zis) {
        CompilationUnit parsed = JavaParser.parse((InputStream)new InputStream(){

            @Override
            public int read(@NonNull byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException("b");
                }
                return zis.read(b, off, len);
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read() throws IOException {
                return zis.read();
            }
        });
        this.findJavaPaths(parsed);
    }

    private void findJavaPaths(CompilationUnit compilationUnit) {
        NodeList typeNames = compilationUnit.getTypes();
        PackageDeclaration packageDeclaration = compilationUnit.getPackageDeclaration().orElse(null);
        String prefix = packageDeclaration == null ? "" : packageDeclaration.getNameAsString() + '.';
        for (TypeDeclaration typeDeclaration : typeNames) {
            this.findJavaPaths(typeDeclaration, prefix);
        }
    }

    private void findJavaPaths(TypeDeclaration<?> typeDeclaration, String packagePrefix) {
        String name = packagePrefix + typeDeclaration.getNameAsString();
        this.classes.add(name);
        for (Node node : typeDeclaration.getChildNodes()) {
            if (!(node instanceof TypeDeclaration)) continue;
            this.findJavaPaths((TypeDeclaration)node, name + '.');
        }
    }

    private void initialise() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        for (Path path : this.inputPaths) {
            this.loadPath(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPath(final Path path) {
        block19: {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String entryName = path.relativize(file).toString().replace(File.separatorChar, '/');
                        if (entryName.endsWith(".java")) {
                            CompilationUnit parsed = JavaParser.parse((Path)file);
                            ClassPath.this.findJavaPaths(parsed);
                        }
                        return super.visitFile(file, attrs);
                    }
                });
                break block19;
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) break block19;
            try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
                ZipEntry e;
                while ((e = zis.getNextEntry()) != null) {
                    try {
                        this.findPaths(e, zis);
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
            }
        }
    }
}

