/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.definition;

import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.OreUtil;

public class OreDictDefinition
implements ProcessingInput {
    public static final OreDictDefinition EMPTY = OreDictDefinition.of("", 0);
    String ore;
    int size;

    private OreDictDefinition(String ore) {
        this(ore, 1);
    }

    private OreDictDefinition(String ore, int size) {
        this.ore = ore;
        this.size = size;
    }

    public static OreDictDefinition of(String ore) {
        return new OreDictDefinition(ore);
    }

    public static OreDictDefinition of(String ore, int size) {
        return new OreDictDefinition(ore, size);
    }

    @Override
    public List<ItemStack> examples() {
        return this.isEmpty() ? Collections.emptyList() : OreUtil.getItemsFromOre(this.ore, this.size);
    }

    public ItemStack getItemStack() {
        return OreUtil.getPreferredItemFromOre(this.ore);
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_190916_E() >= this.size && OreUtil.doesItemHaveOreName(stack, this.ore);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OreDictDefinition that = (OreDictDefinition)o;
        return this.size == that.size && this.ore.equals(that.ore);
    }

    @Override
    public int count() {
        return this.size;
    }

    public String toString() {
        return "ore:" + (this.isEmpty() ? "null" : this.ore) + " * " + this.size;
    }

    public int hashCode() {
        return this.ore.hashCode() * 31 + this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.ore.isEmpty() || this.size == 0;
    }
}

