/*
 * Decompiled with CFR 0.152.
 */
package games.thecodewarrior.bitfont.utils;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RectanglePacker<P> {
    @NotNull
    private Node root;
    private int gapSize = 0;
    private int gapSizeMin = 0;

    public RectanglePacker(int width, int height, int gapSize) {
        this.root = new Node(new Rectangle(0, 0, width, height));
        this.gapSize = gapSize;
        this.gapSizeMin = gapSize / 2;
    }

    public void inspectRectangles(@NotNull List<Rectangle> rectangles) {
        this.root.getRectangles(rectangles);
    }

    @Nullable
    public Rectangle findRectangle(@NotNull P item2) {
        return this.root.findRectange(item2);
    }

    public void clear() {
        this.root = new Node(this.root.rect);
    }

    @Nullable
    public Rectangle insert(int width, int height, @NotNull P o) {
        Node n = this.root.insert(width + this.gapSize, height + this.gapSize, o);
        if (n != null) {
            return new Rectangle(((Node)n).rect.x + this.gapSizeMin, ((Node)n).rect.y + this.gapSizeMin, width, height);
        }
        return null;
    }

    public boolean remove(@NotNull P o) {
        return this.root.remove(o);
    }

    public int getWidth() {
        return ((Node)this.root).rect.width;
    }

    public int getHeight() {
        return ((Node)this.root).rect.height;
    }

    public void expand(int newWidth, int newHeight) {
        if (newWidth == this.getWidth() && newHeight == this.getHeight()) {
            return;
        }
        Node newRoot = new Node(new Rectangle(0, 0, newWidth, newHeight));
        newRoot.split(this.getWidth(), this.getHeight());
        Node parent2 = newRoot;
        if (((Node)((Node)newRoot).left).rect.width != this.getWidth() || ((Node)((Node)newRoot).left).rect.height != this.getHeight()) {
            newRoot.left.split(this.getWidth(), this.getHeight());
            parent2 = newRoot.left;
        }
        parent2.left = this.root;
        this.root = newRoot;
    }

    public static class Rectangle {
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        private Rectangle(int x2, int y, int width, int height) {
            this.x = x2;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        private Rectangle(Rectangle r) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
        }

        public String toString() {
            return "[ " + this.x + ", " + this.y + ", " + this.width + ", " + this.height + " ]";
        }
    }

    private class Node {
        private final Rectangle rect;
        private P occupier = null;
        private Node left = null;
        private Node right = null;

        private Node(Rectangle r) {
            this.rect = r;
        }

        private Rectangle findRectange(P item2) {
            if (this.isLeaf()) {
                if (item2 == this.occupier) {
                    return this.rect;
                }
                return null;
            }
            Rectangle l = this.left.findRectange(item2);
            if (l != null) {
                return l;
            }
            return this.right.findRectange(item2);
        }

        private Node insert(int width, int height, P o) {
            if (!this.isLeaf()) {
                Node r = this.left.insert(width, height, o);
                if (r == null) {
                    r = this.right.insert(width, height, o);
                }
                return r;
            }
            if (this.occupier != null) {
                return null;
            }
            Fit fit = this.fits(width, height);
            switch (fit) {
                case FAIL: {
                    return null;
                }
                case PERFECT: {
                    this.occupier = o;
                    return this;
                }
                case FIT: {
                    this.split(width, height);
                }
            }
            return this.left.insert(width, height, o);
        }

        private boolean isLeaf() {
            return this.left == null;
        }

        private boolean isOccupied() {
            return this.occupier != null || !this.isLeaf();
        }

        private boolean remove(P o) {
            if (this.isLeaf()) {
                if (this.occupier == o) {
                    this.occupier = null;
                    return true;
                }
                return false;
            }
            boolean found = this.left.remove(o);
            if (!found) {
                found = this.right.remove(o);
            }
            if (found && !this.left.isOccupied() && !this.right.isOccupied()) {
                this.left = null;
                this.right = null;
            }
            return found;
        }

        private void split(int width, int height) {
            Rectangle r;
            Rectangle l;
            int dw = this.rect.width - width;
            int dh = this.rect.height - height;
            assert (dw >= 0);
            assert (dh >= 0);
            if (dw > dh) {
                l = new Rectangle(this.rect.x, this.rect.y, width, this.rect.height);
                r = new Rectangle(l.x + width, this.rect.y, this.rect.width - width, this.rect.height);
            } else {
                l = new Rectangle(this.rect.x, this.rect.y, this.rect.width, height);
                r = new Rectangle(this.rect.x, l.y + height, this.rect.width, this.rect.height - height);
            }
            this.left = new Node(l);
            this.right = new Node(r);
        }

        private Fit fits(int width, int height) {
            if (width <= this.rect.width && height <= this.rect.height) {
                if (width == this.rect.width && height == this.rect.height) {
                    return Fit.PERFECT;
                }
                return Fit.FIT;
            }
            return Fit.FAIL;
        }

        private void getRectangles(List<Rectangle> rectangles) {
            rectangles.add(this.rect);
            if (!this.isLeaf()) {
                this.left.getRectangles(rectangles);
                this.right.getRectangles(rectangles);
            }
        }
    }

    private static enum Fit {
        FAIL,
        PERFECT,
        FIT;

    }
}

