/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.util.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import org.apache.commons.io.FileUtils;
import toughasnails.core.ToughAsNails;

public class JsonUtil {
    public static final Gson SERIALIZER = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T getOrCreateConfigFile(File configDir, String configName, T defaults, Type type) {
        File configFile = new File(configDir, configName);
        if (!configFile.exists()) {
            JsonUtil.writeFile(configFile, defaults);
        }
        try {
            return (T)SERIALIZER.fromJson(FileUtils.readFileToString((File)configFile), type);
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error parsing config from json: " + configFile.toString(), (Throwable)e);
            return null;
        }
    }

    protected static boolean writeFile(File outputFile, Object obj) {
        try {
            FileUtils.write((File)outputFile, (CharSequence)SERIALIZER.toJson(obj));
            return true;
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Error writing config file " + outputFile.getAbsolutePath() + ": " + e.getMessage());
            return false;
        }
    }
}

