/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.tileentity;

import com.charles445.simpledifficulty.api.config.ServerConfig;
import com.charles445.simpledifficulty.api.config.ServerOptions;
import com.charles445.simpledifficulty.api.temperature.ITemperatureTileEntity;
import com.charles445.simpledifficulty.block.BlockTemperature;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class TileEntityTemperature
extends TileEntity
implements ITemperatureTileEntity {
    @Override
    public float getInfluence(BlockPos targetPos, double distance) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof BlockTemperature) {
            boolean enabled = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTemperature.ENABLED);
            if (enabled) {
                float activeTemp = ((BlockTemperature)block).getActiveTemperatureMult() * (float)ModConfig.server.temperature.heaterTemperature;
                double fullPowerSq = this.sq(ModConfig.server.temperature.heaterFullPowerRange);
                if (distance < fullPowerSq) {
                    return this.handleStrict(targetPos, activeTemp);
                }
                double distanceDiv = this.sq(ModConfig.server.temperature.heaterMaxRange) - fullPowerSq;
                if (distanceDiv <= 0.0) {
                    return 0.0f;
                }
                return this.handleStrict(targetPos, activeTemp * Math.max(0.0f, 1.0f - (float)((distance - fullPowerSq) / distanceDiv)));
            }
            return 0.0f;
        }
        return 0.0f;
    }

    private float handleStrict(BlockPos targetPos, float distanceTemp) {
        int zinc;
        if (!ServerConfig.instance.getBoolean(ServerOptions.STRICT_HEATERS)) {
            return distanceTemp;
        }
        BlockPos thisPos = this.func_174877_v();
        int curX = targetPos.func_177958_n();
        int curY = targetPos.func_177956_o();
        int curZ = targetPos.func_177952_p();
        int destX = thisPos.func_177958_n();
        int destY = thisPos.func_177956_o();
        int destZ = thisPos.func_177952_p();
        int xinc = curX < destX ? 1 : -1;
        int yinc = curY < destY ? 1 : -1;
        int n = zinc = curZ < destZ ? 1 : -1;
        if (this.isUnprotected(new BlockPos(curX, curY, curZ)) || this.isUnprotected(new BlockPos(destX, destY, destZ))) {
            return 0.0f;
        }
        while (curX != destX || curZ != destZ || curY != destY) {
            if (curX != destX) {
                curX += xinc;
            }
            if (curY != destY) {
                curY += yinc;
            }
            if (curZ != destZ) {
                curZ += zinc;
            }
            if (!this.isUnprotected(new BlockPos(curX, curY, curZ))) continue;
            return 0.0f;
        }
        return distanceTemp;
    }

    private boolean isUnprotected(BlockPos pos) {
        if (!WorldUtil.isChunkLoaded(this.field_145850_b, pos)) {
            return true;
        }
        Chunk chunk = this.field_145850_b.func_72863_F().func_186025_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (!chunk.func_177444_d(pos)) {
            return false;
        }
        return chunk.func_177440_h(pos).func_177956_o() <= pos.func_177956_o();
    }

    private double sq(double d) {
        return d * d;
    }
}

