/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.register;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.SDItems;
import com.charles445.simpledifficulty.config.JsonConfigInternal;
import com.charles445.simpledifficulty.config.json.ExtraItem;
import com.charles445.simpledifficulty.item.ItemArmorTemperature;
import com.charles445.simpledifficulty.item.ItemCanteen;
import com.charles445.simpledifficulty.item.ItemDragonCanteen;
import com.charles445.simpledifficulty.item.ItemIronCanteen;
import com.charles445.simpledifficulty.item.ItemJuice;
import com.charles445.simpledifficulty.item.ItemPurifiedWaterBottle;
import com.charles445.simpledifficulty.item.ItemThermometer;
import com.charles445.simpledifficulty.register.ModCreativeTab;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterItems {

    @Mod.EventBusSubscriber(modid="simpledifficulty")
    public static class Registrar {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            SimpleDifficulty.logger.info("Registering Items");
            SDItems.woolArmorMaterial = EnumHelper.addArmorMaterial((String)"SDWOOL", (String)"simpledifficulty:wool", (int)2, (int[])new int[]{1, 1, 1, 1}, (int)5, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
            SDItems.woolArmorMaterial.repairMaterial = new ItemStack(Blocks.field_150325_L);
            SDItems.armorMaterials.put("woolArmorMaterial", SDItems.woolArmorMaterial);
            SDItems.iceArmorMaterial = EnumHelper.addArmorMaterial((String)"SDICE", (String)"simpleDifficulty:ice", (int)2, (int[])new int[]{1, 1, 1, 1}, (int)5, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
            SDItems.iceArmorMaterial.repairMaterial = new ItemStack(SDItems.ice_chunk);
            SDItems.armorMaterials.put("iceArmorMaterial", SDItems.iceArmorMaterial);
            IForgeRegistry registry = event.getRegistry();
            SDItems.purifiedWaterBottle = Registrar.registerAs("purified_water_bottle", new ItemPurifiedWaterBottle(), (IForgeRegistry<Item>)registry);
            SDItems.juice = Registrar.registerAs("juice", new ItemJuice(), (IForgeRegistry<Item>)registry);
            SDItems.canteen = Registrar.registerAs("canteen", new ItemCanteen(), (IForgeRegistry<Item>)registry);
            SDItems.ironCanteen = Registrar.registerAs("iron_canteen", new ItemIronCanteen(), (IForgeRegistry<Item>)registry);
            SDItems.charcoalFilter = Registrar.registerAs("charcoal_filter", new Item(), (IForgeRegistry<Item>)registry);
            SDItems.ice_chunk = Registrar.registerAs("ice_chunk", new Item(), (IForgeRegistry<Item>)registry);
            SDItems.magma_chunk = Registrar.registerAs("magma_chunk", new Item(), (IForgeRegistry<Item>)registry);
            SDItems.thermometer = Registrar.registerAs("thermometer", new ItemThermometer(), (IForgeRegistry<Item>)registry);
            SDItems.wool_helmet = Registrar.registerAs("wool_helmet", (Item)new ItemArmorTemperature(SDItems.woolArmorMaterial, EntityEquipmentSlot.HEAD), (IForgeRegistry<Item>)registry);
            SDItems.wool_chestplate = Registrar.registerAs("wool_chestplate", (Item)new ItemArmorTemperature(SDItems.woolArmorMaterial, EntityEquipmentSlot.CHEST), (IForgeRegistry<Item>)registry);
            SDItems.wool_leggings = Registrar.registerAs("wool_leggings", (Item)new ItemArmorTemperature(SDItems.woolArmorMaterial, EntityEquipmentSlot.LEGS), (IForgeRegistry<Item>)registry);
            SDItems.wool_boots = Registrar.registerAs("wool_boots", (Item)new ItemArmorTemperature(SDItems.woolArmorMaterial, EntityEquipmentSlot.FEET), (IForgeRegistry<Item>)registry);
            SDItems.ice_helmet = Registrar.registerAs("ice_helmet", (Item)new ItemArmorTemperature(SDItems.iceArmorMaterial, EntityEquipmentSlot.HEAD), (IForgeRegistry<Item>)registry);
            SDItems.ice_chestplate = Registrar.registerAs("ice_chestplate", (Item)new ItemArmorTemperature(SDItems.iceArmorMaterial, EntityEquipmentSlot.CHEST), (IForgeRegistry<Item>)registry);
            SDItems.ice_leggings = Registrar.registerAs("ice_leggings", (Item)new ItemArmorTemperature(SDItems.iceArmorMaterial, EntityEquipmentSlot.LEGS), (IForgeRegistry<Item>)registry);
            SDItems.ice_boots = Registrar.registerAs("ice_boots", (Item)new ItemArmorTemperature(SDItems.iceArmorMaterial, EntityEquipmentSlot.FEET), (IForgeRegistry<Item>)registry);
            block9: for (Map.Entry<String, ExtraItem> entry : JsonConfigInternal.extraItems.entrySet()) {
                String name = entry.getKey();
                ExtraItem extraItem = entry.getValue();
                if (!extraItem.enabled) continue;
                switch (name) {
                    case "dragon_canteen": {
                        Registrar.registerAs(name, new ItemDragonCanteen(extraItem), (IForgeRegistry<Item>)registry);
                        continue block9;
                    }
                    case "frost_rod": 
                    case "frost_powder": {
                        Registrar.registerAs(name, new Item(), (IForgeRegistry<Item>)registry);
                        continue block9;
                    }
                }
                SimpleDifficulty.logger.error("Tried to register invalid extra item: " + name);
            }
        }

        private static Item registerAs(String name, Item newItem, IForgeRegistry<Item> registry) {
            newItem.setRegistryName("simpledifficulty", name);
            newItem.func_77655_b(newItem.getRegistryName().toString());
            newItem.func_77637_a((CreativeTabs)ModCreativeTab.instance);
            registry.register((IForgeRegistryEntry)newItem);
            SDItems.items.put(name, newItem);
            return newItem;
        }
    }
}

